<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepFilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight departure information.
 * @subpackage Structs
 */
class DepFilterCriteriaType extends AbstractStructBase
{
    /**
     * The DepDate
     * Meta information extracted from the WSDL
     * - documentation: Departure date. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepDate;
    /**
     * The StationCode
     * Meta information extracted from the WSDL
     * - documentation: Departure station/airport. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StationCode;
    /**
     * Constructor method for DepFilterCriteriaType
     * @uses DepFilterCriteriaType::setDepDate()
     * @uses DepFilterCriteriaType::setStationCode()
     * @param string $depDate
     * @param string $stationCode
     */
    public function __construct($depDate = null, $stationCode = null)
    {
        $this
            ->setDepDate($depDate)
            ->setStationCode($stationCode);
    }
    /**
     * Get DepDate value
     * @return string
     */
    public function getDepDate()
    {
        return $this->DepDate;
    }
    /**
     * Set DepDate value
     * @param string $depDate
     * @return \StructType\DepFilterCriteriaType
     */
    public function setDepDate($depDate = null)
    {
        // validation for constraint: string
        if (!is_null($depDate) && !is_string($depDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depDate, true), gettype($depDate)), __LINE__);
        }
        $this->DepDate = $depDate;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \StructType\DepFilterCriteriaType
     */
    public function setStationCode($stationCode = null)
    {
        // validation for constraint: string
        if (!is_null($stationCode) && !is_string($stationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stationCode, true), gettype($stationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($stationCode) && mb_strlen($stationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($stationCode)), __LINE__);
        }
        $this->StationCode = $stationCode;
        return $this;
    }
}
