<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedOperatingSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
 * @subpackage Structs
 */
class DatedOperatingSegmentType extends AbstractStructBase
{
    /**
     * The CarrierDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $CarrierDesigCode;
    /**
     * The DatedOperatingSegmentId
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of a dated operating segment used in a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DatedOperatingSegmentId;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a leg within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a disclosure within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisclosureRefID;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Total segment time including the combined air time and connection times of any legs. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month,
     * Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The OperatingCarrierFlightNumberText
     * Meta information extracted from the WSDL
     * - documentation: The numerical designation of a flight as it is operated by a carrier. | Identifies a flight number. 1 to 4 digits. May or may not have leading zeros when less than 4 digits. The use of leading zeros does not create a different Flight
     * Number. For example, Flight Numbers 123 and 0123 are the same.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{1,4}
     * @var string
     */
    public $OperatingCarrierFlightNumberText;
    /**
     * The OperationalSuffixText
     * Meta information extracted from the WSDL
     * - documentation: Used to distinguish two flights having the same flight number and departing from their respective Origin Stations on the same date. | Defines the Operational Suffix which is appended to a flight number.
     * - base: xs:string
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationalSuffixText;
    /**
     * The SecureFlightInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, this segment is subject to US TSA 'Secure Flight' passenger prescreening program. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SecureFlightInd;
    /**
     * The SegmentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the operational flight segment type (e.g. Open, Passive, Service). Encoding Scheme: IATA PADIS 1.4 Codeset FST - Flight Segment Type | Flight segment type. Example: P (PASSIVE) {codeListAgencyName}IATA{/codeListAgencyName}
     * {codeListName}FST Flight Segment Type{/codeListName} {codeListIdentifier}1.4{/codeListIdentifier} | BDT referencing the Segment Type as per PADIS codeset (Flight Segment Type).
     * - base: SegmentTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SegmentTypeCode;
    /**
     * Constructor method for DatedOperatingSegmentType
     * @uses DatedOperatingSegmentType::setCarrierDesigCode()
     * @uses DatedOperatingSegmentType::setDatedOperatingSegmentId()
     * @uses DatedOperatingSegmentType::setCarrierName()
     * @uses DatedOperatingSegmentType::setDatedOperatingLegRefID()
     * @uses DatedOperatingSegmentType::setDisclosureRefID()
     * @uses DatedOperatingSegmentType::setDuration()
     * @uses DatedOperatingSegmentType::setOperatingCarrierFlightNumberText()
     * @uses DatedOperatingSegmentType::setOperationalSuffixText()
     * @uses DatedOperatingSegmentType::setSecureFlightInd()
     * @uses DatedOperatingSegmentType::setSegmentTypeCode()
     * @param string $carrierDesigCode
     * @param string $datedOperatingSegmentId
     * @param string $carrierName
     * @param string[] $datedOperatingLegRefID
     * @param string $disclosureRefID
     * @param string $duration
     * @param string $operatingCarrierFlightNumberText
     * @param string $operationalSuffixText
     * @param bool $secureFlightInd
     * @param string $segmentTypeCode
     */
    public function __construct($carrierDesigCode = null, $datedOperatingSegmentId = null, $carrierName = null, array $datedOperatingLegRefID = array(), $disclosureRefID = null, $duration = null, $operatingCarrierFlightNumberText = null, $operationalSuffixText = null, $secureFlightInd = null, $segmentTypeCode = null)
    {
        $this
            ->setCarrierDesigCode($carrierDesigCode)
            ->setDatedOperatingSegmentId($datedOperatingSegmentId)
            ->setCarrierName($carrierName)
            ->setDatedOperatingLegRefID($datedOperatingLegRefID)
            ->setDisclosureRefID($disclosureRefID)
            ->setDuration($duration)
            ->setOperatingCarrierFlightNumberText($operatingCarrierFlightNumberText)
            ->setOperationalSuffixText($operationalSuffixText)
            ->setSecureFlightInd($secureFlightInd)
            ->setSegmentTypeCode($segmentTypeCode);
    }
    /**
     * Get CarrierDesigCode value
     * @return string
     */
    public function getCarrierDesigCode()
    {
        return $this->CarrierDesigCode;
    }
    /**
     * Set CarrierDesigCode value
     * @param string $carrierDesigCode
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setCarrierDesigCode($carrierDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierDesigCode) && !is_string($carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierDesigCode, true), gettype($carrierDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($carrierDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($carrierDesigCode, true)), __LINE__);
        }
        $this->CarrierDesigCode = $carrierDesigCode;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentId value
     * @return string
     */
    public function getDatedOperatingSegmentId()
    {
        return $this->DatedOperatingSegmentId;
    }
    /**
     * Set DatedOperatingSegmentId value
     * @param string $datedOperatingSegmentId
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setDatedOperatingSegmentId($datedOperatingSegmentId = null)
    {
        // validation for constraint: string
        if (!is_null($datedOperatingSegmentId) && !is_string($datedOperatingSegmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedOperatingSegmentId, true), gettype($datedOperatingSegmentId)), __LINE__);
        }
        $this->DatedOperatingSegmentId = $datedOperatingSegmentId;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]|null
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedOperatingSegmentTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($datedOperatingSegmentTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($datedOperatingSegmentTypeDatedOperatingLegRefIDItem) ? get_class($datedOperatingSegmentTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($datedOperatingSegmentTypeDatedOperatingLegRefIDItem), var_export($datedOperatingSegmentTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DatedOperatingSegmentType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * Set DisclosureRefID value
     * @param string $disclosureRefID
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setDisclosureRefID($disclosureRefID = null)
    {
        // validation for constraint: string
        if (!is_null($disclosureRefID) && !is_string($disclosureRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclosureRefID, true), gettype($disclosureRefID)), __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get OperatingCarrierFlightNumberText value
     * @return string|null
     */
    public function getOperatingCarrierFlightNumberText()
    {
        return $this->OperatingCarrierFlightNumberText;
    }
    /**
     * Set OperatingCarrierFlightNumberText value
     * @param string $operatingCarrierFlightNumberText
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setOperatingCarrierFlightNumberText($operatingCarrierFlightNumberText = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierFlightNumberText) && !is_string($operatingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierFlightNumberText, true), gettype($operatingCarrierFlightNumberText)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,4})
        if (!is_null($operatingCarrierFlightNumberText) && !preg_match('/[0-9]{1,4}/', $operatingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,4}', var_export($operatingCarrierFlightNumberText, true)), __LINE__);
        }
        $this->OperatingCarrierFlightNumberText = $operatingCarrierFlightNumberText;
        return $this;
    }
    /**
     * Get OperationalSuffixText value
     * @return string|null
     */
    public function getOperationalSuffixText()
    {
        return $this->OperationalSuffixText;
    }
    /**
     * Set OperationalSuffixText value
     * @param string $operationalSuffixText
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setOperationalSuffixText($operationalSuffixText = null)
    {
        // validation for constraint: string
        if (!is_null($operationalSuffixText) && !is_string($operationalSuffixText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationalSuffixText, true), gettype($operationalSuffixText)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($operationalSuffixText) && mb_strlen($operationalSuffixText) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($operationalSuffixText)), __LINE__);
        }
        $this->OperationalSuffixText = $operationalSuffixText;
        return $this;
    }
    /**
     * Get SecureFlightInd value
     * @return bool|null
     */
    public function getSecureFlightInd()
    {
        return $this->SecureFlightInd;
    }
    /**
     * Set SecureFlightInd value
     * @param bool $secureFlightInd
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setSecureFlightInd($secureFlightInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($secureFlightInd) && !is_bool($secureFlightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secureFlightInd, true), gettype($secureFlightInd)), __LINE__);
        }
        $this->SecureFlightInd = $secureFlightInd;
        return $this;
    }
    /**
     * Get SegmentTypeCode value
     * @return string|null
     */
    public function getSegmentTypeCode()
    {
        return $this->SegmentTypeCode;
    }
    /**
     * Set SegmentTypeCode value
     * @param string $segmentTypeCode
     * @return \StructType\DatedOperatingSegmentType
     */
    public function setSegmentTypeCode($segmentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentTypeCode) && !is_string($segmentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segmentTypeCode, true), gettype($segmentTypeCode)), __LINE__);
        }
        $this->SegmentTypeCode = $segmentTypeCode;
        return $this;
    }
}
