<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatedMarketingSegmentRef StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to aDatedMarketingSegment. Thiswill be a reference to asingle Dated MarketingSegment within a PassengerSegment in the containedmessage.
 * @subpackage Structs
 */
class DatedMarketingSegmentRef extends AbstractStructBase
{
    /**
     * The DatedMarketingSegmentRefID
     * Meta information extracted from the WSDL
     * - documentation: A reference to a unique identifier of adated marketing segment used in amessage. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $DatedMarketingSegmentRefID;
    /**
     * Constructor method for DatedMarketingSegmentRef
     * @uses DatedMarketingSegmentRef::setDatedMarketingSegmentRefID()
     * @param string[] $datedMarketingSegmentRefID
     */
    public function __construct(array $datedMarketingSegmentRefID = array())
    {
        $this
            ->setDatedMarketingSegmentRefID($datedMarketingSegmentRefID);
    }
    /**
     * Get DatedMarketingSegmentRefID value
     * @return string[]|null
     */
    public function getDatedMarketingSegmentRefID()
    {
        return $this->DatedMarketingSegmentRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegmentRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentRefIDForArrayConstraintsFromSetDatedMarketingSegmentRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $datedMarketingSegmentRefDatedMarketingSegmentRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($datedMarketingSegmentRefDatedMarketingSegmentRefIDItem)) {
                $invalidValues[] = is_object($datedMarketingSegmentRefDatedMarketingSegmentRefIDItem) ? get_class($datedMarketingSegmentRefDatedMarketingSegmentRefIDItem) : sprintf('%s(%s)', gettype($datedMarketingSegmentRefDatedMarketingSegmentRefIDItem), var_export($datedMarketingSegmentRefDatedMarketingSegmentRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegmentRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedMarketingSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedMarketingSegmentRefID
     * @return \StructType\DatedMarketingSegmentRef
     */
    public function setDatedMarketingSegmentRefID(array $datedMarketingSegmentRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentRefIDArrayErrorMessage = self::validateDatedMarketingSegmentRefIDForArrayConstraintsFromSetDatedMarketingSegmentRefID($datedMarketingSegmentRefID))) {
            throw new \InvalidArgumentException($datedMarketingSegmentRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegmentRefID = $datedMarketingSegmentRefID;
        return $this;
    }
    /**
     * Add item to DatedMarketingSegmentRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DatedMarketingSegmentRef
     */
    public function addToDatedMarketingSegmentRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegmentRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedMarketingSegmentRefID[] = $item;
        return $this;
    }
}
