<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeRangeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Date range used to filter responses.
 * @subpackage Structs
 */
class DateTimeRangeType extends AbstractStructBase
{
    /**
     * The FromDateTime
     * Meta information extracted from the WSDL
     * - documentation: Beginning of date range criteria used to filter Order results. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromDateTime;
    /**
     * The ToDateTime
     * Meta information extracted from the WSDL
     * - documentation: End of date range criteria used to filter Order results. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToDateTime;
    /**
     * Constructor method for DateTimeRangeType
     * @uses DateTimeRangeType::setFromDateTime()
     * @uses DateTimeRangeType::setToDateTime()
     * @param string $fromDateTime
     * @param string $toDateTime
     */
    public function __construct($fromDateTime = null, $toDateTime = null)
    {
        $this
            ->setFromDateTime($fromDateTime)
            ->setToDateTime($toDateTime);
    }
    /**
     * Get FromDateTime value
     * @return string|null
     */
    public function getFromDateTime()
    {
        return $this->FromDateTime;
    }
    /**
     * Set FromDateTime value
     * @param string $fromDateTime
     * @return \StructType\DateTimeRangeType
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateTime, true), gettype($fromDateTime)), __LINE__);
        }
        $this->FromDateTime = $fromDateTime;
        return $this;
    }
    /**
     * Get ToDateTime value
     * @return string|null
     */
    public function getToDateTime()
    {
        return $this->ToDateTime;
    }
    /**
     * Set ToDateTime value
     * @param string $toDateTime
     * @return \StructType\DateTimeRangeType
     */
    public function setToDateTime($toDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toDateTime) && !is_string($toDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateTime, true), gettype($toDateTime)), __LINE__);
        }
        $this->ToDateTime = $toDateTime;
        return $this;
    }
}
