<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyConversion StructType
 * Meta information extracted from the WSDL
 * - documentation: Currency Conversion Details
 * @subpackage Structs
 */
class CurrencyConversion extends AbstractStructBase
{
    /**
     * The From
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 0
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 0
     * @var string
     */
    public $To;
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: Exchange rate used for currency conversion. Example: 0.73
     * @var float
     */
    public $Rate;
    /**
     * Constructor method for CurrencyConversion
     * @uses CurrencyConversion::setFrom()
     * @uses CurrencyConversion::setTo()
     * @uses CurrencyConversion::setRate()
     * @param string $from
     * @param string $to
     * @param float $rate
     */
    public function __construct($from = null, $to = null, $rate = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setRate($rate);
    }
    /**
     * Get From value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\CurrencyConversion
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($from) && mb_strlen($from) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($from)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($from) && mb_strlen($from) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \StructType\CurrencyConversion
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($to) && mb_strlen($to) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($to)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($to) && mb_strlen($to) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\CurrencyConversion
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
}
