<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create Order
 * @subpackage Structs
 */
class CreateOrderType extends AbstractStructBase
{
    /**
     * The AcceptOrderItemList
     * Meta information extracted from the WSDL
     * - documentation: A collection of Create Order Item's.
     * - choice: AcceptOrderItemList | AcceptSelectedQuotedOfferList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptOrderItemListType
     */
    public $AcceptOrderItemList;
    /**
     * The AcceptSelectedQuotedOfferList
     * Meta information extracted from the WSDL
     * - documentation: An ability to accept selected offer items from a Quoted Offer.
     * - choice: AcceptOrderItemList | AcceptSelectedQuotedOfferList
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AcceptSelectedQuotedOfferListType
     */
    public $AcceptSelectedQuotedOfferList;
    /**
     * Constructor method for CreateOrderType
     * @uses CreateOrderType::setAcceptOrderItemList()
     * @uses CreateOrderType::setAcceptSelectedQuotedOfferList()
     * @param \StructType\AcceptOrderItemListType $acceptOrderItemList
     * @param \StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList
     */
    public function __construct(\StructType\AcceptOrderItemListType $acceptOrderItemList = null, \StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList = null)
    {
        $this
            ->setAcceptOrderItemList($acceptOrderItemList)
            ->setAcceptSelectedQuotedOfferList($acceptSelectedQuotedOfferList);
    }
    /**
     * Get AcceptOrderItemList value
     * @return \StructType\AcceptOrderItemListType
     */
    public function getAcceptOrderItemList()
    {
        return isset($this->AcceptOrderItemList) ? $this->AcceptOrderItemList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptOrderItemList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptOrderItemList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptOrderItemListForChoiceConstraintsFromSetAcceptOrderItemList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptSelectedQuotedOfferList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptOrderItemList can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptOrderItemList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptOrderItemList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptOrderItemListType $acceptOrderItemList
     * @return \StructType\CreateOrderType
     */
    public function setAcceptOrderItemList(\StructType\AcceptOrderItemListType $acceptOrderItemList = null)
    {
        // validation for constraint: choice(AcceptOrderItemList, AcceptSelectedQuotedOfferList)
        if ('' !== ($acceptOrderItemListChoiceErrorMessage = self::validateAcceptOrderItemListForChoiceConstraintsFromSetAcceptOrderItemList($acceptOrderItemList))) {
            throw new \InvalidArgumentException($acceptOrderItemListChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptOrderItemList) || (is_array($acceptOrderItemList) && empty($acceptOrderItemList))) {
            unset($this->AcceptOrderItemList);
        } else {
            $this->AcceptOrderItemList = $acceptOrderItemList;
        }
        return $this;
    }
    /**
     * Get AcceptSelectedQuotedOfferList value
     * @return \StructType\AcceptSelectedQuotedOfferListType
     */
    public function getAcceptSelectedQuotedOfferList()
    {
        return isset($this->AcceptSelectedQuotedOfferList) ? $this->AcceptSelectedQuotedOfferList : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAcceptSelectedQuotedOfferList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptSelectedQuotedOfferList method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAcceptSelectedQuotedOfferListForChoiceConstraintsFromSetAcceptSelectedQuotedOfferList($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AcceptOrderItemList',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AcceptSelectedQuotedOfferList can\'t be set as the property %s is already set. Only one property must be set among these properties: AcceptSelectedQuotedOfferList, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AcceptSelectedQuotedOfferList value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList
     * @return \StructType\CreateOrderType
     */
    public function setAcceptSelectedQuotedOfferList(\StructType\AcceptSelectedQuotedOfferListType $acceptSelectedQuotedOfferList = null)
    {
        // validation for constraint: choice(AcceptOrderItemList, AcceptSelectedQuotedOfferList)
        if ('' !== ($acceptSelectedQuotedOfferListChoiceErrorMessage = self::validateAcceptSelectedQuotedOfferListForChoiceConstraintsFromSetAcceptSelectedQuotedOfferList($acceptSelectedQuotedOfferList))) {
            throw new \InvalidArgumentException($acceptSelectedQuotedOfferListChoiceErrorMessage, __LINE__);
        }
        if (is_null($acceptSelectedQuotedOfferList) || (is_array($acceptSelectedQuotedOfferList) && empty($acceptSelectedQuotedOfferList))) {
            unset($this->AcceptSelectedQuotedOfferList);
        } else {
            $this->AcceptSelectedQuotedOfferList = $acceptSelectedQuotedOfferList;
        }
        return $this;
    }
}
