<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponType StructType
 * Meta information extracted from the WSDL
 * - documentation: The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
 * @subpackage Structs
 */
class CouponType extends AbstractStructBase
{
    /**
     * The CouponNumber
     * Meta information extracted from the WSDL
     * - documentation: Number assigned to the issued coupon. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CouponNumber;
    /**
     * The BaggageAllowanceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a BaggageAllowanceID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $BaggageAllowanceRefID;
    /**
     * The ConnectedCouponNumber
     * Meta information extracted from the WSDL
     * - documentation: The coupon number to which this document is connected. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ConnectedCouponNumber;
    /**
     * The ConsumedAtIssuanceInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the coupon is consumed at issuance. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ConsumedAtIssuanceInd;
    /**
     * The CouponMediaTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type of media used to issue the coupon (e.g. Electronic, Paper, Other). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CouponMediaTypeCode;
    /**
     * The CouponRefNumber
     * Meta information extracted from the WSDL
     * - documentation: The sequential number (segment identifier) of an individual flight segment. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CouponRefNumber;
    /**
     * The CouponSeqNumber
     * Meta information extracted from the WSDL
     * - documentation: The number representing the order in which this coupon was used or is to be used. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $CouponSeqNumber;
    /**
     * The CouponStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Current status of the flight/ value coupon. Example: E (Exchanged/Reissued) | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CouponStatusCode;
    /**
     * The CouponValidityPeriod
     * Meta information extracted from the WSDL
     * - documentation: Date range a coupon is valid for with an optional time component.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CouponValidityPeriodType
     */
    public $CouponValidityPeriod;
    /**
     * The CurrentCouponFlightInfoRef
     * Meta information extracted from the WSDL
     * - documentation: Current Coupon Flight Information Latest flight information as it relates to a coupon eg Current CheckedIn Flown.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CurrentCouponFlightInfoRefType
     */
    public $CurrentCouponFlightInfoRef;
    /**
     * The ExcessBaggage
     * Meta information extracted from the WSDL
     * - documentation: Excess baggage information displayed on a coupon.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExcessBaggageType
     */
    public $ExcessBaggage;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code as ticketed. Example: Y26 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareBasisCode;
    /**
     * The FiledFee
     * Meta information extracted from the WSDL
     * - documentation: Filed fee information relating to a coupon, including the Bankers Seller Rate used to convert the filed amount into the currency of payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FiledFeeType
     */
    public $FiledFee;
    /**
     * The InvolIndCode
     * Meta information extracted from the WSDL
     * - documentation: Involuntary charge transaction code. Example: I (Involuntary - no reason given). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvolIndCode;
    /**
     * The NonCommissionableInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the document is non-commissionable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NonCommissionableInd;
    /**
     * The NonInterlineableInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the document is non-interlineable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NonInterlineableInd;
    /**
     * The NonRefundableInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the fare is non refundable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NonRefundableInd;
    /**
     * The NonReissuableNonExchInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the document is non-reissuable and/or exchangeable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $NonReissuableNonExchInd;
    /**
     * The ProductCharacteristic
     * Meta information extracted from the WSDL
     * - documentation: Contextual information to further describe something using a key-value pair.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KeyValuePropertyType
     */
    public $ProductCharacteristic;
    /**
     * The PromotionRefID
     * Meta information extracted from the WSDL
     * - documentation: Promotion code ID or number. Example: PROMO123. Used in conjunction with Link (Promotion URL), Issuer (Promotion Owner or Sponsor) and Remarks (Promotion remarks). | An identifier is a character string used to uniquely identify one
     * instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PromotionRefID;
    /**
     * The RemarkText
     * Meta information extracted from the WSDL
     * - documentation: Free text to provide further information related to the document and/or coupon. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemarkText;
    /**
     * The ResChangeInfo
     * Meta information extracted from the WSDL
     * - documentation: Reservation change information which describes new flight information as it relates to a changed reservation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResChangeInfoType
     */
    public $ResChangeInfo;
    /**
     * The RFIC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Code Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services) | Enumeration values for Reason for Issuance codes. {codeListAgencyName}PADIS{/codeListAgencyName}
     * {codeListName}Special condition{/codeListName} {codeListIdentifier}4183{/codeListIdentifier} | Additional BDT to specify the reason for issuance code.
     * - base: RFIC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $RFIC;
    /**
     * The RFISC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge) | Enumeration values for Reason for Issuance sub codes. Examples: 0CC (First Checked Bag). 0B1 (In-flight Entertainment). 0BX
     * (Lounge). 0B3 (Meal/ Beverage). 0B5 (Pre-reserved Seat Assignment). 0G6 (Priority Boarding). {codeListAgencyName}ATPCo{/codeListAgencyName} {codeListName}Optional Services Industry Sub Codes{/codeListName} | Additional BDT to specify the reason for
     * issuance sub code.
     * - base: RFISC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFISC;
    /**
     * The RFISC_Desc
     * Meta information extracted from the WSDL
     * - documentation: Corresponding description for the Reason for Issuance subcode. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFISC_Desc;
    /**
     * The ServiceDeliveryDate
     * Meta information extracted from the WSDL
     * - documentation: The date that the associated service to this Coupon should be delivered. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceDeliveryDate;
    /**
     * The ServiceDeliveryProviderLocationCode
     * Meta information extracted from the WSDL
     * - documentation: The name of the service provider who will perform the service as described on an EMD coupon. | Enumeration set for the Location Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}Location code{/codeListName}
     * {enumerationURI}http://www.iata.org/publications/Pages/code-search.aspx{/enumerationURI} | Additional BDT to specify the codeset which defines the IATA airport or city codes.
     * - base: IATA_LocationCodeContentType
     * - length: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceDeliveryProviderLocationCode;
    /**
     * The ServiceDeliveryProviderName
     * Meta information extracted from the WSDL
     * - documentation: The name of the service provider who will perform the service as described on an EMD coupon. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceDeliveryProviderName;
    /**
     * The ServiceQty
     * Meta information extracted from the WSDL
     * - documentation: Number of services of the same type that are included in an EMD coupon. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ServiceQty;
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Service ID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ServiceRefID;
    /**
     * The SettlementAuthorizationID
     * Meta information extracted from the WSDL
     * - documentation: A reference ID generated by the validating carrier authorizing settlement of a coupon. Example: AUTH123 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is
     * managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SettlementAuthorizationID;
    /**
     * The SoldAirlineInfo
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentRefListType
     */
    public $SoldAirlineInfo;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - documentation: The value associated to a single coupon of a miscellaneous document (e.g. 100 USD).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $ValueAmount;
    /**
     * Constructor method for CouponType
     * @uses CouponType::setCouponNumber()
     * @uses CouponType::setBaggageAllowanceRefID()
     * @uses CouponType::setConnectedCouponNumber()
     * @uses CouponType::setConsumedAtIssuanceInd()
     * @uses CouponType::setCouponMediaTypeCode()
     * @uses CouponType::setCouponRefNumber()
     * @uses CouponType::setCouponSeqNumber()
     * @uses CouponType::setCouponStatusCode()
     * @uses CouponType::setCouponValidityPeriod()
     * @uses CouponType::setCurrentCouponFlightInfoRef()
     * @uses CouponType::setExcessBaggage()
     * @uses CouponType::setFareBasisCode()
     * @uses CouponType::setFiledFee()
     * @uses CouponType::setInvolIndCode()
     * @uses CouponType::setNonCommissionableInd()
     * @uses CouponType::setNonInterlineableInd()
     * @uses CouponType::setNonRefundableInd()
     * @uses CouponType::setNonReissuableNonExchInd()
     * @uses CouponType::setProductCharacteristic()
     * @uses CouponType::setPromotionRefID()
     * @uses CouponType::setRemarkText()
     * @uses CouponType::setResChangeInfo()
     * @uses CouponType::setRFIC()
     * @uses CouponType::setRFISC()
     * @uses CouponType::setRFISC_Desc()
     * @uses CouponType::setServiceDeliveryDate()
     * @uses CouponType::setServiceDeliveryProviderLocationCode()
     * @uses CouponType::setServiceDeliveryProviderName()
     * @uses CouponType::setServiceQty()
     * @uses CouponType::setServiceRefID()
     * @uses CouponType::setSettlementAuthorizationID()
     * @uses CouponType::setSoldAirlineInfo()
     * @uses CouponType::setValueAmount()
     * @param float $couponNumber
     * @param string[] $baggageAllowanceRefID
     * @param float $connectedCouponNumber
     * @param bool $consumedAtIssuanceInd
     * @param string $couponMediaTypeCode
     * @param float $couponRefNumber
     * @param float $couponSeqNumber
     * @param string $couponStatusCode
     * @param \StructType\CouponValidityPeriodType $couponValidityPeriod
     * @param \StructType\CurrentCouponFlightInfoRefType $currentCouponFlightInfoRef
     * @param \StructType\ExcessBaggageType $excessBaggage
     * @param string $fareBasisCode
     * @param \StructType\FiledFeeType $filedFee
     * @param string $involIndCode
     * @param bool $nonCommissionableInd
     * @param bool $nonInterlineableInd
     * @param bool $nonRefundableInd
     * @param bool $nonReissuableNonExchInd
     * @param \StructType\KeyValuePropertyType $productCharacteristic
     * @param string $promotionRefID
     * @param string $remarkText
     * @param \StructType\ResChangeInfoType $resChangeInfo
     * @param string $rFIC
     * @param string $rFISC
     * @param string $rFISC_Desc
     * @param string $serviceDeliveryDate
     * @param string $serviceDeliveryProviderLocationCode
     * @param string $serviceDeliveryProviderName
     * @param float $serviceQty
     * @param string[] $serviceRefID
     * @param string $settlementAuthorizationID
     * @param \StructType\PaxSegmentRefListType $soldAirlineInfo
     * @param \StructType\AmountType $valueAmount
     */
    public function __construct($couponNumber = null, array $baggageAllowanceRefID = array(), $connectedCouponNumber = null, $consumedAtIssuanceInd = null, $couponMediaTypeCode = null, $couponRefNumber = null, $couponSeqNumber = null, $couponStatusCode = null, \StructType\CouponValidityPeriodType $couponValidityPeriod = null, \StructType\CurrentCouponFlightInfoRefType $currentCouponFlightInfoRef = null, \StructType\ExcessBaggageType $excessBaggage = null, $fareBasisCode = null, \StructType\FiledFeeType $filedFee = null, $involIndCode = null, $nonCommissionableInd = null, $nonInterlineableInd = null, $nonRefundableInd = null, $nonReissuableNonExchInd = null, \StructType\KeyValuePropertyType $productCharacteristic = null, $promotionRefID = null, $remarkText = null, \StructType\ResChangeInfoType $resChangeInfo = null, $rFIC = null, $rFISC = null, $rFISC_Desc = null, $serviceDeliveryDate = null, $serviceDeliveryProviderLocationCode = null, $serviceDeliveryProviderName = null, $serviceQty = null, array $serviceRefID = array(), $settlementAuthorizationID = null, \StructType\PaxSegmentRefListType $soldAirlineInfo = null, \StructType\AmountType $valueAmount = null)
    {
        $this
            ->setCouponNumber($couponNumber)
            ->setBaggageAllowanceRefID($baggageAllowanceRefID)
            ->setConnectedCouponNumber($connectedCouponNumber)
            ->setConsumedAtIssuanceInd($consumedAtIssuanceInd)
            ->setCouponMediaTypeCode($couponMediaTypeCode)
            ->setCouponRefNumber($couponRefNumber)
            ->setCouponSeqNumber($couponSeqNumber)
            ->setCouponStatusCode($couponStatusCode)
            ->setCouponValidityPeriod($couponValidityPeriod)
            ->setCurrentCouponFlightInfoRef($currentCouponFlightInfoRef)
            ->setExcessBaggage($excessBaggage)
            ->setFareBasisCode($fareBasisCode)
            ->setFiledFee($filedFee)
            ->setInvolIndCode($involIndCode)
            ->setNonCommissionableInd($nonCommissionableInd)
            ->setNonInterlineableInd($nonInterlineableInd)
            ->setNonRefundableInd($nonRefundableInd)
            ->setNonReissuableNonExchInd($nonReissuableNonExchInd)
            ->setProductCharacteristic($productCharacteristic)
            ->setPromotionRefID($promotionRefID)
            ->setRemarkText($remarkText)
            ->setResChangeInfo($resChangeInfo)
            ->setRFIC($rFIC)
            ->setRFISC($rFISC)
            ->setRFISC_Desc($rFISC_Desc)
            ->setServiceDeliveryDate($serviceDeliveryDate)
            ->setServiceDeliveryProviderLocationCode($serviceDeliveryProviderLocationCode)
            ->setServiceDeliveryProviderName($serviceDeliveryProviderName)
            ->setServiceQty($serviceQty)
            ->setServiceRefID($serviceRefID)
            ->setSettlementAuthorizationID($settlementAuthorizationID)
            ->setSoldAirlineInfo($soldAirlineInfo)
            ->setValueAmount($valueAmount);
    }
    /**
     * Get CouponNumber value
     * @return float
     */
    public function getCouponNumber()
    {
        return $this->CouponNumber;
    }
    /**
     * Set CouponNumber value
     * @param float $couponNumber
     * @return \StructType\CouponType
     */
    public function setCouponNumber($couponNumber = null)
    {
        // validation for constraint: float
        if (!is_null($couponNumber) && !(is_float($couponNumber) || is_numeric($couponNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($couponNumber, true), gettype($couponNumber)), __LINE__);
        }
        $this->CouponNumber = $couponNumber;
        return $this;
    }
    /**
     * Get BaggageAllowanceRefID value
     * @return string[]|null
     */
    public function getBaggageAllowanceRefID()
    {
        return $this->BaggageAllowanceRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageAllowanceRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAllowanceRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponTypeBaggageAllowanceRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($couponTypeBaggageAllowanceRefIDItem)) {
                $invalidValues[] = is_object($couponTypeBaggageAllowanceRefIDItem) ? get_class($couponTypeBaggageAllowanceRefIDItem) : sprintf('%s(%s)', gettype($couponTypeBaggageAllowanceRefIDItem), var_export($couponTypeBaggageAllowanceRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string[] $baggageAllowanceRefID
     * @return \StructType\CouponType
     */
    public function setBaggageAllowanceRefID(array $baggageAllowanceRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageAllowanceRefIDArrayErrorMessage = self::validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID($baggageAllowanceRefID))) {
            throw new \InvalidArgumentException($baggageAllowanceRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($baggageAllowanceRefID) && count($baggageAllowanceRefID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($baggageAllowanceRefID)), __LINE__);
        }
        $this->BaggageAllowanceRefID = $baggageAllowanceRefID;
        return $this;
    }
    /**
     * Add item to BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CouponType
     */
    public function addToBaggageAllowanceRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BaggageAllowanceRefID) && count($this->BaggageAllowanceRefID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BaggageAllowanceRefID)), __LINE__);
        }
        $this->BaggageAllowanceRefID[] = $item;
        return $this;
    }
    /**
     * Get ConnectedCouponNumber value
     * @return float|null
     */
    public function getConnectedCouponNumber()
    {
        return $this->ConnectedCouponNumber;
    }
    /**
     * Set ConnectedCouponNumber value
     * @param float $connectedCouponNumber
     * @return \StructType\CouponType
     */
    public function setConnectedCouponNumber($connectedCouponNumber = null)
    {
        // validation for constraint: float
        if (!is_null($connectedCouponNumber) && !(is_float($connectedCouponNumber) || is_numeric($connectedCouponNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($connectedCouponNumber, true), gettype($connectedCouponNumber)), __LINE__);
        }
        $this->ConnectedCouponNumber = $connectedCouponNumber;
        return $this;
    }
    /**
     * Get ConsumedAtIssuanceInd value
     * @return bool|null
     */
    public function getConsumedAtIssuanceInd()
    {
        return $this->ConsumedAtIssuanceInd;
    }
    /**
     * Set ConsumedAtIssuanceInd value
     * @param bool $consumedAtIssuanceInd
     * @return \StructType\CouponType
     */
    public function setConsumedAtIssuanceInd($consumedAtIssuanceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($consumedAtIssuanceInd) && !is_bool($consumedAtIssuanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consumedAtIssuanceInd, true), gettype($consumedAtIssuanceInd)), __LINE__);
        }
        $this->ConsumedAtIssuanceInd = $consumedAtIssuanceInd;
        return $this;
    }
    /**
     * Get CouponMediaTypeCode value
     * @return string|null
     */
    public function getCouponMediaTypeCode()
    {
        return $this->CouponMediaTypeCode;
    }
    /**
     * Set CouponMediaTypeCode value
     * @param string $couponMediaTypeCode
     * @return \StructType\CouponType
     */
    public function setCouponMediaTypeCode($couponMediaTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($couponMediaTypeCode) && !is_string($couponMediaTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponMediaTypeCode, true), gettype($couponMediaTypeCode)), __LINE__);
        }
        $this->CouponMediaTypeCode = $couponMediaTypeCode;
        return $this;
    }
    /**
     * Get CouponRefNumber value
     * @return float|null
     */
    public function getCouponRefNumber()
    {
        return $this->CouponRefNumber;
    }
    /**
     * Set CouponRefNumber value
     * @param float $couponRefNumber
     * @return \StructType\CouponType
     */
    public function setCouponRefNumber($couponRefNumber = null)
    {
        // validation for constraint: float
        if (!is_null($couponRefNumber) && !(is_float($couponRefNumber) || is_numeric($couponRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($couponRefNumber, true), gettype($couponRefNumber)), __LINE__);
        }
        $this->CouponRefNumber = $couponRefNumber;
        return $this;
    }
    /**
     * Get CouponSeqNumber value
     * @return float|null
     */
    public function getCouponSeqNumber()
    {
        return $this->CouponSeqNumber;
    }
    /**
     * Set CouponSeqNumber value
     * @param float $couponSeqNumber
     * @return \StructType\CouponType
     */
    public function setCouponSeqNumber($couponSeqNumber = null)
    {
        // validation for constraint: float
        if (!is_null($couponSeqNumber) && !(is_float($couponSeqNumber) || is_numeric($couponSeqNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($couponSeqNumber, true), gettype($couponSeqNumber)), __LINE__);
        }
        $this->CouponSeqNumber = $couponSeqNumber;
        return $this;
    }
    /**
     * Get CouponStatusCode value
     * @return string|null
     */
    public function getCouponStatusCode()
    {
        return $this->CouponStatusCode;
    }
    /**
     * Set CouponStatusCode value
     * @param string $couponStatusCode
     * @return \StructType\CouponType
     */
    public function setCouponStatusCode($couponStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($couponStatusCode) && !is_string($couponStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponStatusCode, true), gettype($couponStatusCode)), __LINE__);
        }
        $this->CouponStatusCode = $couponStatusCode;
        return $this;
    }
    /**
     * Get CouponValidityPeriod value
     * @return \StructType\CouponValidityPeriodType|null
     */
    public function getCouponValidityPeriod()
    {
        return $this->CouponValidityPeriod;
    }
    /**
     * Set CouponValidityPeriod value
     * @param \StructType\CouponValidityPeriodType $couponValidityPeriod
     * @return \StructType\CouponType
     */
    public function setCouponValidityPeriod(\StructType\CouponValidityPeriodType $couponValidityPeriod = null)
    {
        $this->CouponValidityPeriod = $couponValidityPeriod;
        return $this;
    }
    /**
     * Get CurrentCouponFlightInfoRef value
     * @return \StructType\CurrentCouponFlightInfoRefType|null
     */
    public function getCurrentCouponFlightInfoRef()
    {
        return $this->CurrentCouponFlightInfoRef;
    }
    /**
     * Set CurrentCouponFlightInfoRef value
     * @param \StructType\CurrentCouponFlightInfoRefType $currentCouponFlightInfoRef
     * @return \StructType\CouponType
     */
    public function setCurrentCouponFlightInfoRef(\StructType\CurrentCouponFlightInfoRefType $currentCouponFlightInfoRef = null)
    {
        $this->CurrentCouponFlightInfoRef = $currentCouponFlightInfoRef;
        return $this;
    }
    /**
     * Get ExcessBaggage value
     * @return \StructType\ExcessBaggageType|null
     */
    public function getExcessBaggage()
    {
        return $this->ExcessBaggage;
    }
    /**
     * Set ExcessBaggage value
     * @param \StructType\ExcessBaggageType $excessBaggage
     * @return \StructType\CouponType
     */
    public function setExcessBaggage(\StructType\ExcessBaggageType $excessBaggage = null)
    {
        $this->ExcessBaggage = $excessBaggage;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\CouponType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get FiledFee value
     * @return \StructType\FiledFeeType|null
     */
    public function getFiledFee()
    {
        return $this->FiledFee;
    }
    /**
     * Set FiledFee value
     * @param \StructType\FiledFeeType $filedFee
     * @return \StructType\CouponType
     */
    public function setFiledFee(\StructType\FiledFeeType $filedFee = null)
    {
        $this->FiledFee = $filedFee;
        return $this;
    }
    /**
     * Get InvolIndCode value
     * @return string|null
     */
    public function getInvolIndCode()
    {
        return $this->InvolIndCode;
    }
    /**
     * Set InvolIndCode value
     * @param string $involIndCode
     * @return \StructType\CouponType
     */
    public function setInvolIndCode($involIndCode = null)
    {
        // validation for constraint: string
        if (!is_null($involIndCode) && !is_string($involIndCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($involIndCode, true), gettype($involIndCode)), __LINE__);
        }
        $this->InvolIndCode = $involIndCode;
        return $this;
    }
    /**
     * Get NonCommissionableInd value
     * @return bool|null
     */
    public function getNonCommissionableInd()
    {
        return $this->NonCommissionableInd;
    }
    /**
     * Set NonCommissionableInd value
     * @param bool $nonCommissionableInd
     * @return \StructType\CouponType
     */
    public function setNonCommissionableInd($nonCommissionableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonCommissionableInd) && !is_bool($nonCommissionableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonCommissionableInd, true), gettype($nonCommissionableInd)), __LINE__);
        }
        $this->NonCommissionableInd = $nonCommissionableInd;
        return $this;
    }
    /**
     * Get NonInterlineableInd value
     * @return bool|null
     */
    public function getNonInterlineableInd()
    {
        return $this->NonInterlineableInd;
    }
    /**
     * Set NonInterlineableInd value
     * @param bool $nonInterlineableInd
     * @return \StructType\CouponType
     */
    public function setNonInterlineableInd($nonInterlineableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonInterlineableInd) && !is_bool($nonInterlineableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonInterlineableInd, true), gettype($nonInterlineableInd)), __LINE__);
        }
        $this->NonInterlineableInd = $nonInterlineableInd;
        return $this;
    }
    /**
     * Get NonRefundableInd value
     * @return bool|null
     */
    public function getNonRefundableInd()
    {
        return $this->NonRefundableInd;
    }
    /**
     * Set NonRefundableInd value
     * @param bool $nonRefundableInd
     * @return \StructType\CouponType
     */
    public function setNonRefundableInd($nonRefundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableInd) && !is_bool($nonRefundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundableInd, true), gettype($nonRefundableInd)), __LINE__);
        }
        $this->NonRefundableInd = $nonRefundableInd;
        return $this;
    }
    /**
     * Get NonReissuableNonExchInd value
     * @return bool|null
     */
    public function getNonReissuableNonExchInd()
    {
        return $this->NonReissuableNonExchInd;
    }
    /**
     * Set NonReissuableNonExchInd value
     * @param bool $nonReissuableNonExchInd
     * @return \StructType\CouponType
     */
    public function setNonReissuableNonExchInd($nonReissuableNonExchInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonReissuableNonExchInd) && !is_bool($nonReissuableNonExchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonReissuableNonExchInd, true), gettype($nonReissuableNonExchInd)), __LINE__);
        }
        $this->NonReissuableNonExchInd = $nonReissuableNonExchInd;
        return $this;
    }
    /**
     * Get ProductCharacteristic value
     * @return \StructType\KeyValuePropertyType|null
     */
    public function getProductCharacteristic()
    {
        return $this->ProductCharacteristic;
    }
    /**
     * Set ProductCharacteristic value
     * @param \StructType\KeyValuePropertyType $productCharacteristic
     * @return \StructType\CouponType
     */
    public function setProductCharacteristic(\StructType\KeyValuePropertyType $productCharacteristic = null)
    {
        $this->ProductCharacteristic = $productCharacteristic;
        return $this;
    }
    /**
     * Get PromotionRefID value
     * @return string|null
     */
    public function getPromotionRefID()
    {
        return $this->PromotionRefID;
    }
    /**
     * Set PromotionRefID value
     * @param string $promotionRefID
     * @return \StructType\CouponType
     */
    public function setPromotionRefID($promotionRefID = null)
    {
        // validation for constraint: string
        if (!is_null($promotionRefID) && !is_string($promotionRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionRefID, true), gettype($promotionRefID)), __LINE__);
        }
        $this->PromotionRefID = $promotionRefID;
        return $this;
    }
    /**
     * Get RemarkText value
     * @return string|null
     */
    public function getRemarkText()
    {
        return $this->RemarkText;
    }
    /**
     * Set RemarkText value
     * @param string $remarkText
     * @return \StructType\CouponType
     */
    public function setRemarkText($remarkText = null)
    {
        // validation for constraint: string
        if (!is_null($remarkText) && !is_string($remarkText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkText, true), gettype($remarkText)), __LINE__);
        }
        $this->RemarkText = $remarkText;
        return $this;
    }
    /**
     * Get ResChangeInfo value
     * @return \StructType\ResChangeInfoType|null
     */
    public function getResChangeInfo()
    {
        return $this->ResChangeInfo;
    }
    /**
     * Set ResChangeInfo value
     * @param \StructType\ResChangeInfoType $resChangeInfo
     * @return \StructType\CouponType
     */
    public function setResChangeInfo(\StructType\ResChangeInfoType $resChangeInfo = null)
    {
        $this->ResChangeInfo = $resChangeInfo;
        return $this;
    }
    /**
     * Get RFIC value
     * @return string|null
     */
    public function getRFIC()
    {
        return $this->RFIC;
    }
    /**
     * Set RFIC value
     * @param string $rFIC
     * @return \StructType\CouponType
     */
    public function setRFIC($rFIC = null)
    {
        // validation for constraint: string
        if (!is_null($rFIC) && !is_string($rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFIC, true), gettype($rFIC)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($rFIC) && !preg_match('/[0-9A-Z]{1,3}/', $rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($rFIC, true)), __LINE__);
        }
        $this->RFIC = $rFIC;
        return $this;
    }
    /**
     * Get RFISC value
     * @return string|null
     */
    public function getRFISC()
    {
        return $this->RFISC;
    }
    /**
     * Set RFISC value
     * @param string $rFISC
     * @return \StructType\CouponType
     */
    public function setRFISC($rFISC = null)
    {
        // validation for constraint: string
        if (!is_null($rFISC) && !is_string($rFISC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFISC, true), gettype($rFISC)), __LINE__);
        }
        $this->RFISC = $rFISC;
        return $this;
    }
    /**
     * Get RFISC_Desc value
     * @return string|null
     */
    public function getRFISC_Desc()
    {
        return $this->RFISC_Desc;
    }
    /**
     * Set RFISC_Desc value
     * @param string $rFISC_Desc
     * @return \StructType\CouponType
     */
    public function setRFISC_Desc($rFISC_Desc = null)
    {
        // validation for constraint: string
        if (!is_null($rFISC_Desc) && !is_string($rFISC_Desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFISC_Desc, true), gettype($rFISC_Desc)), __LINE__);
        }
        $this->RFISC_Desc = $rFISC_Desc;
        return $this;
    }
    /**
     * Get ServiceDeliveryDate value
     * @return string|null
     */
    public function getServiceDeliveryDate()
    {
        return $this->ServiceDeliveryDate;
    }
    /**
     * Set ServiceDeliveryDate value
     * @param string $serviceDeliveryDate
     * @return \StructType\CouponType
     */
    public function setServiceDeliveryDate($serviceDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDeliveryDate) && !is_string($serviceDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDeliveryDate, true), gettype($serviceDeliveryDate)), __LINE__);
        }
        $this->ServiceDeliveryDate = $serviceDeliveryDate;
        return $this;
    }
    /**
     * Get ServiceDeliveryProviderLocationCode value
     * @return string|null
     */
    public function getServiceDeliveryProviderLocationCode()
    {
        return $this->ServiceDeliveryProviderLocationCode;
    }
    /**
     * Set ServiceDeliveryProviderLocationCode value
     * @param string $serviceDeliveryProviderLocationCode
     * @return \StructType\CouponType
     */
    public function setServiceDeliveryProviderLocationCode($serviceDeliveryProviderLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDeliveryProviderLocationCode) && !is_string($serviceDeliveryProviderLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDeliveryProviderLocationCode, true), gettype($serviceDeliveryProviderLocationCode)), __LINE__);
        }
        // validation for constraint: length(3)
        if (!is_null($serviceDeliveryProviderLocationCode) && mb_strlen($serviceDeliveryProviderLocationCode) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 3', mb_strlen($serviceDeliveryProviderLocationCode)), __LINE__);
        }
        $this->ServiceDeliveryProviderLocationCode = $serviceDeliveryProviderLocationCode;
        return $this;
    }
    /**
     * Get ServiceDeliveryProviderName value
     * @return string|null
     */
    public function getServiceDeliveryProviderName()
    {
        return $this->ServiceDeliveryProviderName;
    }
    /**
     * Set ServiceDeliveryProviderName value
     * @param string $serviceDeliveryProviderName
     * @return \StructType\CouponType
     */
    public function setServiceDeliveryProviderName($serviceDeliveryProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDeliveryProviderName) && !is_string($serviceDeliveryProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDeliveryProviderName, true), gettype($serviceDeliveryProviderName)), __LINE__);
        }
        $this->ServiceDeliveryProviderName = $serviceDeliveryProviderName;
        return $this;
    }
    /**
     * Get ServiceQty value
     * @return float|null
     */
    public function getServiceQty()
    {
        return $this->ServiceQty;
    }
    /**
     * Set ServiceQty value
     * @param float $serviceQty
     * @return \StructType\CouponType
     */
    public function setServiceQty($serviceQty = null)
    {
        // validation for constraint: float
        if (!is_null($serviceQty) && !(is_float($serviceQty) || is_numeric($serviceQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($serviceQty, true), gettype($serviceQty)), __LINE__);
        }
        $this->ServiceQty = $serviceQty;
        return $this;
    }
    /**
     * Get ServiceRefID value
     * @return string[]|null
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceRefIDForArrayConstraintsFromSetServiceRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $couponTypeServiceRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($couponTypeServiceRefIDItem)) {
                $invalidValues[] = is_object($couponTypeServiceRefIDItem) ? get_class($couponTypeServiceRefIDItem) : sprintf('%s(%s)', gettype($couponTypeServiceRefIDItem), var_export($couponTypeServiceRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceRefID value
     * @throws \InvalidArgumentException
     * @param string[] $serviceRefID
     * @return \StructType\CouponType
     */
    public function setServiceRefID(array $serviceRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceRefIDArrayErrorMessage = self::validateServiceRefIDForArrayConstraintsFromSetServiceRefID($serviceRefID))) {
            throw new \InvalidArgumentException($serviceRefIDArrayErrorMessage, __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Add item to ServiceRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CouponType
     */
    public function addToServiceRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ServiceRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceRefID[] = $item;
        return $this;
    }
    /**
     * Get SettlementAuthorizationID value
     * @return string|null
     */
    public function getSettlementAuthorizationID()
    {
        return $this->SettlementAuthorizationID;
    }
    /**
     * Set SettlementAuthorizationID value
     * @param string $settlementAuthorizationID
     * @return \StructType\CouponType
     */
    public function setSettlementAuthorizationID($settlementAuthorizationID = null)
    {
        // validation for constraint: string
        if (!is_null($settlementAuthorizationID) && !is_string($settlementAuthorizationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settlementAuthorizationID, true), gettype($settlementAuthorizationID)), __LINE__);
        }
        $this->SettlementAuthorizationID = $settlementAuthorizationID;
        return $this;
    }
    /**
     * Get SoldAirlineInfo value
     * @return \StructType\PaxSegmentRefListType|null
     */
    public function getSoldAirlineInfo()
    {
        return $this->SoldAirlineInfo;
    }
    /**
     * Set SoldAirlineInfo value
     * @param \StructType\PaxSegmentRefListType $soldAirlineInfo
     * @return \StructType\CouponType
     */
    public function setSoldAirlineInfo(\StructType\PaxSegmentRefListType $soldAirlineInfo = null)
    {
        $this->SoldAirlineInfo = $soldAirlineInfo;
        return $this;
    }
    /**
     * Get ValueAmount value
     * @return \StructType\AmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }
    /**
     * Set ValueAmount value
     * @param \StructType\AmountType $valueAmount
     * @return \StructType\CouponType
     */
    public function setValueAmount(\StructType\AmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }
}
