<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionRate StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the rate used to convert the local currency into the billing currency. Do we want to define an official name for the Billing Currency?
 * @subpackage Structs
 */
class ConversionRate extends AbstractStructBase
{
    /**
     * The BaseCurCode
     * Meta information extracted from the WSDL
     * - documentation: The currency of the denominator
     * - use: optional
     * @var string
     */
    public $BaseCurCode;
    /**
     * The BaseMultiplierValue
     * Meta information extracted from the WSDL
     * - documentation: The multiplier of the Rate. Base Unit, Code or Rate. Base Currency. Code
     * - use: optional
     * @var float
     */
    public $BaseMultiplierValue;
    /**
     * The BaseUnitCode
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure of the denominator
     * - use: optional
     * @var string
     */
    public $BaseUnitCode;
    /**
     * The CurCode
     * Meta information extracted from the WSDL
     * - documentation: The currency of the numerator
     * - use: optional
     * @var string
     */
    public $CurCode;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - documentation: Whether the number is an integer, decimal, real number or percentage
     * - use: optional
     * @var string
     */
    public $Format;
    /**
     * The MultiplierValue
     * Meta information extracted from the WSDL
     * - documentation: The multiplier of the Rate. Unit. Code or Rate. Currency. Code
     * - use: optional
     * @var float
     */
    public $MultiplierValue;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure of the numerator
     * - use: optional
     * @var string
     */
    public $UnitCode;
    /**
     * Constructor method for ConversionRate
     * @uses ConversionRate::setBaseCurCode()
     * @uses ConversionRate::setBaseMultiplierValue()
     * @uses ConversionRate::setBaseUnitCode()
     * @uses ConversionRate::setCurCode()
     * @uses ConversionRate::setFormat()
     * @uses ConversionRate::setMultiplierValue()
     * @uses ConversionRate::setUnitCode()
     * @param string $baseCurCode
     * @param float $baseMultiplierValue
     * @param string $baseUnitCode
     * @param string $curCode
     * @param string $format
     * @param float $multiplierValue
     * @param string $unitCode
     */
    public function __construct($baseCurCode = null, $baseMultiplierValue = null, $baseUnitCode = null, $curCode = null, $format = null, $multiplierValue = null, $unitCode = null)
    {
        $this
            ->setBaseCurCode($baseCurCode)
            ->setBaseMultiplierValue($baseMultiplierValue)
            ->setBaseUnitCode($baseUnitCode)
            ->setCurCode($curCode)
            ->setFormat($format)
            ->setMultiplierValue($multiplierValue)
            ->setUnitCode($unitCode);
    }
    /**
     * Get BaseCurCode value
     * @return string|null
     */
    public function getBaseCurCode()
    {
        return $this->BaseCurCode;
    }
    /**
     * Set BaseCurCode value
     * @param string $baseCurCode
     * @return \StructType\ConversionRate
     */
    public function setBaseCurCode($baseCurCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurCode) && !is_string($baseCurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurCode, true), gettype($baseCurCode)), __LINE__);
        }
        $this->BaseCurCode = $baseCurCode;
        return $this;
    }
    /**
     * Get BaseMultiplierValue value
     * @return float|null
     */
    public function getBaseMultiplierValue()
    {
        return $this->BaseMultiplierValue;
    }
    /**
     * Set BaseMultiplierValue value
     * @param float $baseMultiplierValue
     * @return \StructType\ConversionRate
     */
    public function setBaseMultiplierValue($baseMultiplierValue = null)
    {
        // validation for constraint: float
        if (!is_null($baseMultiplierValue) && !(is_float($baseMultiplierValue) || is_numeric($baseMultiplierValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseMultiplierValue, true), gettype($baseMultiplierValue)), __LINE__);
        }
        $this->BaseMultiplierValue = $baseMultiplierValue;
        return $this;
    }
    /**
     * Get BaseUnitCode value
     * @return string|null
     */
    public function getBaseUnitCode()
    {
        return $this->BaseUnitCode;
    }
    /**
     * Set BaseUnitCode value
     * @param string $baseUnitCode
     * @return \StructType\ConversionRate
     */
    public function setBaseUnitCode($baseUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($baseUnitCode) && !is_string($baseUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseUnitCode, true), gettype($baseUnitCode)), __LINE__);
        }
        $this->BaseUnitCode = $baseUnitCode;
        return $this;
    }
    /**
     * Get CurCode value
     * @return string|null
     */
    public function getCurCode()
    {
        return $this->CurCode;
    }
    /**
     * Set CurCode value
     * @param string $curCode
     * @return \StructType\ConversionRate
     */
    public function setCurCode($curCode = null)
    {
        // validation for constraint: string
        if (!is_null($curCode) && !is_string($curCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curCode, true), gettype($curCode)), __LINE__);
        }
        $this->CurCode = $curCode;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\ConversionRate
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get MultiplierValue value
     * @return float|null
     */
    public function getMultiplierValue()
    {
        return $this->MultiplierValue;
    }
    /**
     * Set MultiplierValue value
     * @param float $multiplierValue
     * @return \StructType\ConversionRate
     */
    public function setMultiplierValue($multiplierValue = null)
    {
        // validation for constraint: float
        if (!is_null($multiplierValue) && !(is_float($multiplierValue) || is_numeric($multiplierValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($multiplierValue, true), gettype($multiplierValue)), __LINE__);
        }
        $this->MultiplierValue = $multiplierValue;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\ConversionRate
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
}
