<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionType StructType
 * Meta information extracted from the WSDL
 * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
 * @subpackage Structs
 */
class CommissionType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Commission amount and currency code. Example: 20 USD
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The CommissionCode
     * Meta information extracted from the WSDL
     * - documentation: Commission code. Example: 1000, BFST | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommissionCode;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - documentation: Commission percentage. Example: 20 | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * The PercentageAppliedToAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount to which the percentage will be applied. For Example: Net Amount Gross Amoun Difference between the Net and Gross amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PercentageAppliedToAmount;
    /**
     * The TaxableInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, the commission amount specified is subject to Tax/VAT. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TaxableInd;
    /**
     * Constructor method for CommissionType
     * @uses CommissionType::setAmount()
     * @uses CommissionType::setCommissionCode()
     * @uses CommissionType::setPercentage()
     * @uses CommissionType::setPercentageAppliedToAmount()
     * @uses CommissionType::setTaxableInd()
     * @param \StructType\AmountType $amount
     * @param string $commissionCode
     * @param float $percentage
     * @param \StructType\AmountType $percentageAppliedToAmount
     * @param bool $taxableInd
     */
    public function __construct(\StructType\AmountType $amount = null, $commissionCode = null, $percentage = null, \StructType\AmountType $percentageAppliedToAmount = null, $taxableInd = null)
    {
        $this
            ->setAmount($amount)
            ->setCommissionCode($commissionCode)
            ->setPercentage($percentage)
            ->setPercentageAppliedToAmount($percentageAppliedToAmount)
            ->setTaxableInd($taxableInd);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\CommissionType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CommissionCode value
     * @return string|null
     */
    public function getCommissionCode()
    {
        return $this->CommissionCode;
    }
    /**
     * Set CommissionCode value
     * @param string $commissionCode
     * @return \StructType\CommissionType
     */
    public function setCommissionCode($commissionCode = null)
    {
        // validation for constraint: string
        if (!is_null($commissionCode) && !is_string($commissionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionCode, true), gettype($commissionCode)), __LINE__);
        }
        $this->CommissionCode = $commissionCode;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\CommissionType
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get PercentageAppliedToAmount value
     * @return \StructType\AmountType|null
     */
    public function getPercentageAppliedToAmount()
    {
        return $this->PercentageAppliedToAmount;
    }
    /**
     * Set PercentageAppliedToAmount value
     * @param \StructType\AmountType $percentageAppliedToAmount
     * @return \StructType\CommissionType
     */
    public function setPercentageAppliedToAmount(\StructType\AmountType $percentageAppliedToAmount = null)
    {
        $this->PercentageAppliedToAmount = $percentageAppliedToAmount;
        return $this;
    }
    /**
     * Get TaxableInd value
     * @return bool|null
     */
    public function getTaxableInd()
    {
        return $this->TaxableInd;
    }
    /**
     * Set TaxableInd value
     * @param bool $taxableInd
     * @return \StructType\CommissionType
     */
    public function setTaxableInd($taxableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxableInd) && !is_bool($taxableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxableInd, true), gettype($taxableInd)), __LINE__);
        }
        $this->TaxableInd = $taxableInd;
        return $this;
    }
}
