<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commission StructType
 * Meta information extracted from the WSDL
 * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
 * @subpackage Structs
 */
class Commission extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description text for the commision.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Description;
    /**
     * The CommissionCode
     * Meta information extracted from the WSDL
     * - documentation: Commission code. Example: 1000, BFST. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * @var string
     */
    public $CommissionCode;
    /**
     * Constructor method for Commission
     * @uses Commission::setDescription()
     * @uses Commission::setCommissionCode()
     * @param string[] $description
     * @param string $commissionCode
     */
    public function __construct(array $description = array(), $commissionCode = null)
    {
        $this
            ->setDescription($description)
            ->setCommissionCode($commissionCode);
    }
    /**
     * Get Description value
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commissionDescriptionItem) {
            // validation for constraint: itemType
            if (!is_string($commissionDescriptionItem)) {
                $invalidValues[] = is_object($commissionDescriptionItem) ? get_class($commissionDescriptionItem) : sprintf('%s(%s)', gettype($commissionDescriptionItem), var_export($commissionDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param string[] $description
     * @return \StructType\Commission
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Commission
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get CommissionCode value
     * @return string|null
     */
    public function getCommissionCode()
    {
        return $this->CommissionCode;
    }
    /**
     * Set CommissionCode value
     * @param string $commissionCode
     * @return \StructType\Commission
     */
    public function setCommissionCode($commissionCode = null)
    {
        // validation for constraint: string
        if (!is_null($commissionCode) && !is_string($commissionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissionCode, true), gettype($commissionCode)), __LINE__);
        }
        $this->CommissionCode = $commissionCode;
        return $this;
    }
}
