<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollectionPointTax StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax data breakdown by collection point for XF(Passenger Facility Fee) and ZP(federal tax segment) taxes.
 * @subpackage Structs
 */
class CollectionPointTax extends AbstractStructBase
{
    /**
     * The AirportAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount filed by the airport in the currency applicable to the geographical location of the airport.
     * @var \StructType\AmountType
     */
    public $AirportAmount;
    /**
     * The Station
     * @var \StructType\Station
     */
    public $Station;
    /**
     * Constructor method for CollectionPointTax
     * @uses CollectionPointTax::setAirportAmount()
     * @uses CollectionPointTax::setStation()
     * @param \StructType\AmountType $airportAmount
     * @param \StructType\Station $station
     */
    public function __construct(\StructType\AmountType $airportAmount = null, \StructType\Station $station = null)
    {
        $this
            ->setAirportAmount($airportAmount)
            ->setStation($station);
    }
    /**
     * Get AirportAmount value
     * @return \StructType\AmountType|null
     */
    public function getAirportAmount()
    {
        return $this->AirportAmount;
    }
    /**
     * Set AirportAmount value
     * @param \StructType\AmountType $airportAmount
     * @return \StructType\CollectionPointTax
     */
    public function setAirportAmount(\StructType\AmountType $airportAmount = null)
    {
        $this->AirportAmount = $airportAmount;
        return $this;
    }
    /**
     * Get Station value
     * @return \StructType\Station|null
     */
    public function getStation()
    {
        return $this->Station;
    }
    /**
     * Set Station value
     * @param \StructType\Station $station
     * @return \StructType\CollectionPointTax
     */
    public function setStation(\StructType\Station $station = null)
    {
        $this->Station = $station;
        return $this;
    }
}
