<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearancePayeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: The party receiving funds as a result of a clearance for a claim it has made
 * @subpackage Structs
 */
class ClearancePayeeType extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc
     * - choice: Carrier | Org | TravelAgency
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearanceCarrierType
     */
    public $Carrier;
    /**
     * The Org
     * Meta information extracted from the WSDL
     * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - choice: Carrier | Org | TravelAgency
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearanceOrgType
     */
    public $Org;
    /**
     * The TravelAgency
     * Meta information extracted from the WSDL
     * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
     * tours.
     * - choice: Carrier | Org | TravelAgency
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearanceTravelAgencyType
     */
    public $TravelAgency;
    /**
     * Constructor method for ClearancePayeeType
     * @uses ClearancePayeeType::setCarrier()
     * @uses ClearancePayeeType::setOrg()
     * @uses ClearancePayeeType::setTravelAgency()
     * @param \StructType\ClearanceCarrierType $carrier
     * @param \StructType\ClearanceOrgType $org
     * @param \StructType\ClearanceTravelAgencyType $travelAgency
     */
    public function __construct(\StructType\ClearanceCarrierType $carrier = null, \StructType\ClearanceOrgType $org = null, \StructType\ClearanceTravelAgencyType $travelAgency = null)
    {
        $this
            ->setCarrier($carrier)
            ->setOrg($org)
            ->setTravelAgency($travelAgency);
    }
    /**
     * Get Carrier value
     * @return \StructType\ClearanceCarrierType
     */
    public function getCarrier()
    {
        return isset($this->Carrier) ? $this->Carrier : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCarrier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrier method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCarrierForChoiceConstraintsFromSetCarrier($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Org',
            'TravelAgency',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Carrier can\'t be set as the property %s is already set. Only one property must be set among these properties: Carrier, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Carrier value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceCarrierType $carrier
     * @return \StructType\ClearancePayeeType
     */
    public function setCarrier(\StructType\ClearanceCarrierType $carrier = null)
    {
        // validation for constraint: choice(Carrier, Org, TravelAgency)
        if ('' !== ($carrierChoiceErrorMessage = self::validateCarrierForChoiceConstraintsFromSetCarrier($carrier))) {
            throw new \InvalidArgumentException($carrierChoiceErrorMessage, __LINE__);
        }
        if (is_null($carrier) || (is_array($carrier) && empty($carrier))) {
            unset($this->Carrier);
        } else {
            $this->Carrier = $carrier;
        }
        return $this;
    }
    /**
     * Get Org value
     * @return \StructType\ClearanceOrgType
     */
    public function getOrg()
    {
        return isset($this->Org) ? $this->Org : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrg method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrgForChoiceConstraintsFromSetOrg($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Carrier',
            'TravelAgency',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Org can\'t be set as the property %s is already set. Only one property must be set among these properties: Org, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Org value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceOrgType $org
     * @return \StructType\ClearancePayeeType
     */
    public function setOrg(\StructType\ClearanceOrgType $org = null)
    {
        // validation for constraint: choice(Carrier, Org, TravelAgency)
        if ('' !== ($orgChoiceErrorMessage = self::validateOrgForChoiceConstraintsFromSetOrg($org))) {
            throw new \InvalidArgumentException($orgChoiceErrorMessage, __LINE__);
        }
        if (is_null($org) || (is_array($org) && empty($org))) {
            unset($this->Org);
        } else {
            $this->Org = $org;
        }
        return $this;
    }
    /**
     * Get TravelAgency value
     * @return \StructType\ClearanceTravelAgencyType
     */
    public function getTravelAgency()
    {
        return isset($this->TravelAgency) ? $this->TravelAgency : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTravelAgency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelAgency method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTravelAgencyForChoiceConstraintsFromSetTravelAgency($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Carrier',
            'Org',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TravelAgency can\'t be set as the property %s is already set. Only one property must be set among these properties: TravelAgency, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TravelAgency value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClearanceTravelAgencyType $travelAgency
     * @return \StructType\ClearancePayeeType
     */
    public function setTravelAgency(\StructType\ClearanceTravelAgencyType $travelAgency = null)
    {
        // validation for constraint: choice(Carrier, Org, TravelAgency)
        if ('' !== ($travelAgencyChoiceErrorMessage = self::validateTravelAgencyForChoiceConstraintsFromSetTravelAgency($travelAgency))) {
            throw new \InvalidArgumentException($travelAgencyChoiceErrorMessage, __LINE__);
        }
        if (is_null($travelAgency) || (is_array($travelAgency) && empty($travelAgency))) {
            unset($this->TravelAgency);
        } else {
            $this->TravelAgency = $travelAgency;
        }
        return $this;
    }
}
