<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearancePayeeDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data defining the Clearance Payee and relevant to its operations.
 * @subpackage Structs
 */
class ClearancePayeeDataType extends AbstractStructBase
{
    /**
     * The ClearancePayee
     * Meta information extracted from the WSDL
     * - documentation: The party receiving funds as a result of a clearance for a claim it has made
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ClearancePayeeType
     */
    public $ClearancePayee;
    /**
     * The ClearancePayeeReconciliationID
     * Meta information extracted from the WSDL
     * - documentation: identifier provided by the Clearance Payee to support internal financial processes, for example reconciliation. If this identifier is included in the clearance request then it must be included in all messages thereafter where it is
     * provided as an option. | Airline Reference identifier is a character string that is managed by the carrier.
     * - base: xs:token
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: ([A-Za-z0-9]{1,15})
     * @var string
     */
    public $ClearancePayeeReconciliationID;
    /**
     * Constructor method for ClearancePayeeDataType
     * @uses ClearancePayeeDataType::setClearancePayee()
     * @uses ClearancePayeeDataType::setClearancePayeeReconciliationID()
     * @param \StructType\ClearancePayeeType $clearancePayee
     * @param string $clearancePayeeReconciliationID
     */
    public function __construct(\StructType\ClearancePayeeType $clearancePayee = null, $clearancePayeeReconciliationID = null)
    {
        $this
            ->setClearancePayee($clearancePayee)
            ->setClearancePayeeReconciliationID($clearancePayeeReconciliationID);
    }
    /**
     * Get ClearancePayee value
     * @return \StructType\ClearancePayeeType
     */
    public function getClearancePayee()
    {
        return $this->ClearancePayee;
    }
    /**
     * Set ClearancePayee value
     * @param \StructType\ClearancePayeeType $clearancePayee
     * @return \StructType\ClearancePayeeDataType
     */
    public function setClearancePayee(\StructType\ClearancePayeeType $clearancePayee = null)
    {
        $this->ClearancePayee = $clearancePayee;
        return $this;
    }
    /**
     * Get ClearancePayeeReconciliationID value
     * @return string|null
     */
    public function getClearancePayeeReconciliationID()
    {
        return $this->ClearancePayeeReconciliationID;
    }
    /**
     * Set ClearancePayeeReconciliationID value
     * @param string $clearancePayeeReconciliationID
     * @return \StructType\ClearancePayeeDataType
     */
    public function setClearancePayeeReconciliationID($clearancePayeeReconciliationID = null)
    {
        // validation for constraint: string
        if (!is_null($clearancePayeeReconciliationID) && !is_string($clearancePayeeReconciliationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearancePayeeReconciliationID, true), gettype($clearancePayeeReconciliationID)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($clearancePayeeReconciliationID) && mb_strlen($clearancePayeeReconciliationID) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($clearancePayeeReconciliationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($clearancePayeeReconciliationID) && mb_strlen($clearancePayeeReconciliationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($clearancePayeeReconciliationID)), __LINE__);
        }
        // validation for constraint: pattern(([A-Za-z0-9]{1,15}))
        if (!is_null($clearancePayeeReconciliationID) && !preg_match('/([A-Za-z0-9]{1,15})/', $clearancePayeeReconciliationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Za-z0-9]{1,15})', var_export($clearancePayeeReconciliationID, true)), __LINE__);
        }
        $this->ClearancePayeeReconciliationID = $clearancePayeeReconciliationID;
        return $this;
    }
}
