<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearanceCarrierType StructType
 * Meta information extracted from the WSDL
 * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc
 * @subpackage Structs
 */
class ClearanceCarrierType extends AbstractStructBase
{
    /**
     * The AirlineAccountingCode
     * Meta information extracted from the WSDL
     * - documentation: IATA assigned numerical code of three digits only. Used to identify airlines for the purpose of financial reporting and settlement. | A code is a character string of letters, numbers, special characters (except escape sequences), and
     * symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AirlineAccountingCode;
    /**
     * The AirlineDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $AirlineDesigCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ClearanceCarrierType
     * @uses ClearanceCarrierType::setAirlineAccountingCode()
     * @uses ClearanceCarrierType::setAirlineDesigCode()
     * @uses ClearanceCarrierType::setName()
     * @param string $airlineAccountingCode
     * @param string $airlineDesigCode
     * @param string $name
     */
    public function __construct($airlineAccountingCode = null, $airlineDesigCode = null, $name = null)
    {
        $this
            ->setAirlineAccountingCode($airlineAccountingCode)
            ->setAirlineDesigCode($airlineDesigCode)
            ->setName($name);
    }
    /**
     * Get AirlineAccountingCode value
     * @return string
     */
    public function getAirlineAccountingCode()
    {
        return $this->AirlineAccountingCode;
    }
    /**
     * Set AirlineAccountingCode value
     * @param string $airlineAccountingCode
     * @return \StructType\ClearanceCarrierType
     */
    public function setAirlineAccountingCode($airlineAccountingCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineAccountingCode) && !is_string($airlineAccountingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineAccountingCode, true), gettype($airlineAccountingCode)), __LINE__);
        }
        $this->AirlineAccountingCode = $airlineAccountingCode;
        return $this;
    }
    /**
     * Get AirlineDesigCode value
     * @return string
     */
    public function getAirlineDesigCode()
    {
        return $this->AirlineDesigCode;
    }
    /**
     * Set AirlineDesigCode value
     * @param string $airlineDesigCode
     * @return \StructType\ClearanceCarrierType
     */
    public function setAirlineDesigCode($airlineDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineDesigCode) && !is_string($airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineDesigCode, true), gettype($airlineDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($airlineDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $airlineDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($airlineDesigCode, true)), __LINE__);
        }
        $this->AirlineDesigCode = $airlineDesigCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ClearanceCarrierType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
