<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOrCancelFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Amount added on to a charge for a specific product, purpose, or service.
 * @subpackage Structs
 */
class ChangeOrCancelFeeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Fee Amount. Example: 500 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The ApproximateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this fee is approximate. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ApproximateInd;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Fee/ surcharge Description. Example: U.S Customs User Fee | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The MaximumAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an Maximum fee amount which will be charged when a variable fee amount is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MaximumAmount;
    /**
     * The MinimumAmount
     * Meta information extracted from the WSDL
     * - documentation: Stores an Minimum fee amount which will be charged when a variable fee amount is effective.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $MinimumAmount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Stores a percentage which will be used to determine the Fee to be charged in conjunction or not with minimum and maximum amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Percent;
    /**
     * Constructor method for ChangeOrCancelFeeType
     * @uses ChangeOrCancelFeeType::setAmount()
     * @uses ChangeOrCancelFeeType::setApproximateInd()
     * @uses ChangeOrCancelFeeType::setDescText()
     * @uses ChangeOrCancelFeeType::setMaximumAmount()
     * @uses ChangeOrCancelFeeType::setMinimumAmount()
     * @uses ChangeOrCancelFeeType::setPercent()
     * @param \StructType\AmountType $amount
     * @param bool $approximateInd
     * @param string $descText
     * @param \StructType\AmountType $maximumAmount
     * @param \StructType\AmountType $minimumAmount
     * @param float $percent
     */
    public function __construct(\StructType\AmountType $amount = null, $approximateInd = null, $descText = null, \StructType\AmountType $maximumAmount = null, \StructType\AmountType $minimumAmount = null, $percent = null)
    {
        $this
            ->setAmount($amount)
            ->setApproximateInd($approximateInd)
            ->setDescText($descText)
            ->setMaximumAmount($maximumAmount)
            ->setMinimumAmount($minimumAmount)
            ->setPercent($percent);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\ChangeOrCancelFeeType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApproximateInd value
     * @return bool|null
     */
    public function getApproximateInd()
    {
        return $this->ApproximateInd;
    }
    /**
     * Set ApproximateInd value
     * @param bool $approximateInd
     * @return \StructType\ChangeOrCancelFeeType
     */
    public function setApproximateInd($approximateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateInd) && !is_bool($approximateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approximateInd, true), gettype($approximateInd)), __LINE__);
        }
        $this->ApproximateInd = $approximateInd;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\ChangeOrCancelFeeType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get MaximumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMaximumAmount()
    {
        return $this->MaximumAmount;
    }
    /**
     * Set MaximumAmount value
     * @param \StructType\AmountType $maximumAmount
     * @return \StructType\ChangeOrCancelFeeType
     */
    public function setMaximumAmount(\StructType\AmountType $maximumAmount = null)
    {
        $this->MaximumAmount = $maximumAmount;
        return $this;
    }
    /**
     * Get MinimumAmount value
     * @return \StructType\AmountType|null
     */
    public function getMinimumAmount()
    {
        return $this->MinimumAmount;
    }
    /**
     * Set MinimumAmount value
     * @param \StructType\AmountType $minimumAmount
     * @return \StructType\ChangeOrCancelFeeType
     */
    public function setMinimumAmount(\StructType\AmountType $minimumAmount = null)
    {
        $this->MinimumAmount = $minimumAmount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\ChangeOrCancelFeeType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
}
