<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline preferences for a shopping request.
 * @subpackage Structs
 */
class CarrierCriteriaType extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CarrierType
     */
    public $Carrier;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for CarrierCriteriaType
     * @uses CarrierCriteriaType::setCarrier()
     * @uses CarrierCriteriaType::setPrefLevel()
     * @param \StructType\CarrierType $carrier
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct(\StructType\CarrierType $carrier = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setCarrier($carrier)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \StructType\CarrierType $carrier
     * @return \StructType\CarrierCriteriaType
     */
    public function setCarrier(\StructType\CarrierType $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\CarrierCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
