<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelUnpaidOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: An ability to cancel entire un-paid order.
 * @subpackage Structs
 */
class CancelUnpaidOrderType extends AbstractStructBase
{
    /**
     * The OrderRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a specific Order ID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes. Example: UA, BA Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code | The codelist
     * contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution
     * 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined
     * 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The SelectedOrderItem
     * Meta information extracted from the WSDL
     * - documentation: Identifies the list of order items selected.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectedOrderItemType[]
     */
    public $SelectedOrderItem;
    /**
     * Constructor method for CancelUnpaidOrderType
     * @uses CancelUnpaidOrderType::setOrderRefID()
     * @uses CancelUnpaidOrderType::setOwnerCode()
     * @uses CancelUnpaidOrderType::setSelectedOrderItem()
     * @param string $orderRefID
     * @param string $ownerCode
     * @param \StructType\SelectedOrderItemType[] $selectedOrderItem
     */
    public function __construct($orderRefID = null, $ownerCode = null, array $selectedOrderItem = array())
    {
        $this
            ->setOrderRefID($orderRefID)
            ->setOwnerCode($ownerCode)
            ->setSelectedOrderItem($selectedOrderItem);
    }
    /**
     * Get OrderRefID value
     * @return string
     */
    public function getOrderRefID()
    {
        return $this->OrderRefID;
    }
    /**
     * Set OrderRefID value
     * @param string $orderRefID
     * @return \StructType\CancelUnpaidOrderType
     */
    public function setOrderRefID($orderRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderRefID) && !is_string($orderRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderRefID, true), gettype($orderRefID)), __LINE__);
        }
        $this->OrderRefID = $orderRefID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\CancelUnpaidOrderType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get SelectedOrderItem value
     * @return \StructType\SelectedOrderItemType[]|null
     */
    public function getSelectedOrderItem()
    {
        return $this->SelectedOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOrderItemForArrayConstraintsFromSetSelectedOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancelUnpaidOrderTypeSelectedOrderItemItem) {
            // validation for constraint: itemType
            if (!$cancelUnpaidOrderTypeSelectedOrderItemItem instanceof \StructType\SelectedOrderItemType) {
                $invalidValues[] = is_object($cancelUnpaidOrderTypeSelectedOrderItemItem) ? get_class($cancelUnpaidOrderTypeSelectedOrderItemItem) : sprintf('%s(%s)', gettype($cancelUnpaidOrderTypeSelectedOrderItemItem), var_export($cancelUnpaidOrderTypeSelectedOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOrderItem property can only contain items of type \StructType\SelectedOrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOrderItemType[] $selectedOrderItem
     * @return \StructType\CancelUnpaidOrderType
     */
    public function setSelectedOrderItem(array $selectedOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOrderItemArrayErrorMessage = self::validateSelectedOrderItemForArrayConstraintsFromSetSelectedOrderItem($selectedOrderItem))) {
            throw new \InvalidArgumentException($selectedOrderItemArrayErrorMessage, __LINE__);
        }
        $this->SelectedOrderItem = $selectedOrderItem;
        return $this;
    }
    /**
     * Add item to SelectedOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOrderItemType $item
     * @return \StructType\CancelUnpaidOrderType
     */
    public function addToSelectedOrderItem(\StructType\SelectedOrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedOrderItemType) {
            throw new \InvalidArgumentException(sprintf('The SelectedOrderItem property can only contain items of type \StructType\SelectedOrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedOrderItem[] = $item;
        return $this;
    }
}
