<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelOrderRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Ability to cancel an entire Order
 * @subpackage Structs
 */
class CancelOrderRefType extends AbstractStructBase
{
    /**
     * The OrderRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a specific Order ID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderRefID;
    /**
     * Constructor method for CancelOrderRefType
     * @uses CancelOrderRefType::setOrderRefID()
     * @param string $orderRefID
     */
    public function __construct($orderRefID = null)
    {
        $this
            ->setOrderRefID($orderRefID);
    }
    /**
     * Get OrderRefID value
     * @return string
     */
    public function getOrderRefID()
    {
        return $this->OrderRefID;
    }
    /**
     * Set OrderRefID value
     * @param string $orderRefID
     * @return \StructType\CancelOrderRefType
     */
    public function setOrderRefID($orderRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderRefID) && !is_string($orderRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderRefID, true), gettype($orderRefID)), __LINE__);
        }
        $this->OrderRefID = $orderRefID;
        return $this;
    }
}
