<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinCompartmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: A physical aircraft compartment where passenger seats are installed, classified by a given Cabin Type. These compartments are typically defined based on fare paid or facilities and services offered.
 * @subpackage Structs
 */
class CabinCompartmentType extends AbstractStructBase
{
    /**
     * The CabinCompartmentID
     * Meta information extracted from the WSDL
     * - documentation: Identifier assigned by a Carrier which uniquely identifies a Cabin Compartment. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CabinCompartmentID;
    /**
     * The CabinComponent
     * Meta information extracted from the WSDL
     * - documentation: Non-seat related cabin feature or facility (e.g. lavatory, galley, closet, stowage, etc.) Business Identifier Fields: - [Aircraft Group Configuration] (All identifying fields) - Cabin Component Type Code - Cabin Component Name
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CabinComponentType[]
     */
    public $CabinComponent;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeType
     */
    public $CabinType;
    /**
     * The DeckCode
     * Meta information extracted from the WSDL
     * - documentation: Aircraft deck code (Upper, Main, Lower). | Specifies a Deck Code.
     * - base: DeckCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeckCode;
    /**
     * The FirstRowNumber
     * Meta information extracted from the WSDL
     * - documentation: First row number of the Cabin Compartment. | A mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $FirstRowNumber;
    /**
     * The LastRowNumber
     * Meta information extracted from the WSDL
     * - documentation: Last row number of the Cabin Compartment. | A mathematical number used for counting (positive whole number or integer).
     * - base: xs:integer
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $LastRowNumber;
    /**
     * The SeatColumn
     * Meta information extracted from the WSDL
     * - documentation: A sitting place column for a passenger or crew in a cabin compartment on a transport vehicle.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatColumnType[]
     */
    public $SeatColumn;
    /**
     * The SeatRow
     * Meta information extracted from the WSDL
     * - documentation: Row of passenger seats located in the cabin. Business Identifier Fields: - [Aircraft Group Configuration] (All identifying fields) - [Deck] Deck Code - [Cabin Section] Cabin Section ID - Row Number
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatRowType[]
     */
    public $SeatRow;
    /**
     * Constructor method for CabinCompartmentType
     * @uses CabinCompartmentType::setCabinCompartmentID()
     * @uses CabinCompartmentType::setCabinComponent()
     * @uses CabinCompartmentType::setCabinType()
     * @uses CabinCompartmentType::setDeckCode()
     * @uses CabinCompartmentType::setFirstRowNumber()
     * @uses CabinCompartmentType::setLastRowNumber()
     * @uses CabinCompartmentType::setSeatColumn()
     * @uses CabinCompartmentType::setSeatRow()
     * @param string $cabinCompartmentID
     * @param \StructType\CabinComponentType[] $cabinComponent
     * @param \StructType\CabinTypeType $cabinType
     * @param string $deckCode
     * @param int $firstRowNumber
     * @param int $lastRowNumber
     * @param \StructType\SeatColumnType[] $seatColumn
     * @param \StructType\SeatRowType[] $seatRow
     */
    public function __construct($cabinCompartmentID = null, array $cabinComponent = array(), \StructType\CabinTypeType $cabinType = null, $deckCode = null, $firstRowNumber = null, $lastRowNumber = null, array $seatColumn = array(), array $seatRow = array())
    {
        $this
            ->setCabinCompartmentID($cabinCompartmentID)
            ->setCabinComponent($cabinComponent)
            ->setCabinType($cabinType)
            ->setDeckCode($deckCode)
            ->setFirstRowNumber($firstRowNumber)
            ->setLastRowNumber($lastRowNumber)
            ->setSeatColumn($seatColumn)
            ->setSeatRow($seatRow);
    }
    /**
     * Get CabinCompartmentID value
     * @return string|null
     */
    public function getCabinCompartmentID()
    {
        return $this->CabinCompartmentID;
    }
    /**
     * Set CabinCompartmentID value
     * @param string $cabinCompartmentID
     * @return \StructType\CabinCompartmentType
     */
    public function setCabinCompartmentID($cabinCompartmentID = null)
    {
        // validation for constraint: string
        if (!is_null($cabinCompartmentID) && !is_string($cabinCompartmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinCompartmentID, true), gettype($cabinCompartmentID)), __LINE__);
        }
        $this->CabinCompartmentID = $cabinCompartmentID;
        return $this;
    }
    /**
     * Get CabinComponent value
     * @return \StructType\CabinComponentType[]|null
     */
    public function getCabinComponent()
    {
        return $this->CabinComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinComponentForArrayConstraintsFromSetCabinComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinCompartmentTypeCabinComponentItem) {
            // validation for constraint: itemType
            if (!$cabinCompartmentTypeCabinComponentItem instanceof \StructType\CabinComponentType) {
                $invalidValues[] = is_object($cabinCompartmentTypeCabinComponentItem) ? get_class($cabinCompartmentTypeCabinComponentItem) : sprintf('%s(%s)', gettype($cabinCompartmentTypeCabinComponentItem), var_export($cabinCompartmentTypeCabinComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinComponent property can only contain items of type \StructType\CabinComponentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinComponentType[] $cabinComponent
     * @return \StructType\CabinCompartmentType
     */
    public function setCabinComponent(array $cabinComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinComponentArrayErrorMessage = self::validateCabinComponentForArrayConstraintsFromSetCabinComponent($cabinComponent))) {
            throw new \InvalidArgumentException($cabinComponentArrayErrorMessage, __LINE__);
        }
        $this->CabinComponent = $cabinComponent;
        return $this;
    }
    /**
     * Add item to CabinComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinComponentType $item
     * @return \StructType\CabinCompartmentType
     */
    public function addToCabinComponent(\StructType\CabinComponentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinComponentType) {
            throw new \InvalidArgumentException(sprintf('The CabinComponent property can only contain items of type \StructType\CabinComponentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinComponent[] = $item;
        return $this;
    }
    /**
     * Get CabinType value
     * @return \StructType\CabinTypeType|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @param \StructType\CabinTypeType $cabinType
     * @return \StructType\CabinCompartmentType
     */
    public function setCabinType(\StructType\CabinTypeType $cabinType = null)
    {
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get DeckCode value
     * @return string|null
     */
    public function getDeckCode()
    {
        return $this->DeckCode;
    }
    /**
     * Set DeckCode value
     * @param string $deckCode
     * @return \StructType\CabinCompartmentType
     */
    public function setDeckCode($deckCode = null)
    {
        // validation for constraint: string
        if (!is_null($deckCode) && !is_string($deckCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deckCode, true), gettype($deckCode)), __LINE__);
        }
        $this->DeckCode = $deckCode;
        return $this;
    }
    /**
     * Get FirstRowNumber value
     * @return int|null
     */
    public function getFirstRowNumber()
    {
        return $this->FirstRowNumber;
    }
    /**
     * Set FirstRowNumber value
     * @param int $firstRowNumber
     * @return \StructType\CabinCompartmentType
     */
    public function setFirstRowNumber($firstRowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($firstRowNumber) && !(is_int($firstRowNumber) || ctype_digit($firstRowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firstRowNumber, true), gettype($firstRowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($firstRowNumber) && $firstRowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($firstRowNumber, true)), __LINE__);
        }
        $this->FirstRowNumber = $firstRowNumber;
        return $this;
    }
    /**
     * Get LastRowNumber value
     * @return int|null
     */
    public function getLastRowNumber()
    {
        return $this->LastRowNumber;
    }
    /**
     * Set LastRowNumber value
     * @param int $lastRowNumber
     * @return \StructType\CabinCompartmentType
     */
    public function setLastRowNumber($lastRowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lastRowNumber) && !(is_int($lastRowNumber) || ctype_digit($lastRowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastRowNumber, true), gettype($lastRowNumber)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lastRowNumber) && $lastRowNumber < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lastRowNumber, true)), __LINE__);
        }
        $this->LastRowNumber = $lastRowNumber;
        return $this;
    }
    /**
     * Get SeatColumn value
     * @return \StructType\SeatColumnType[]|null
     */
    public function getSeatColumn()
    {
        return $this->SeatColumn;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatColumn method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatColumn method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatColumnForArrayConstraintsFromSetSeatColumn(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinCompartmentTypeSeatColumnItem) {
            // validation for constraint: itemType
            if (!$cabinCompartmentTypeSeatColumnItem instanceof \StructType\SeatColumnType) {
                $invalidValues[] = is_object($cabinCompartmentTypeSeatColumnItem) ? get_class($cabinCompartmentTypeSeatColumnItem) : sprintf('%s(%s)', gettype($cabinCompartmentTypeSeatColumnItem), var_export($cabinCompartmentTypeSeatColumnItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatColumn property can only contain items of type \StructType\SeatColumnType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatColumn value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatColumnType[] $seatColumn
     * @return \StructType\CabinCompartmentType
     */
    public function setSeatColumn(array $seatColumn = array())
    {
        // validation for constraint: array
        if ('' !== ($seatColumnArrayErrorMessage = self::validateSeatColumnForArrayConstraintsFromSetSeatColumn($seatColumn))) {
            throw new \InvalidArgumentException($seatColumnArrayErrorMessage, __LINE__);
        }
        $this->SeatColumn = $seatColumn;
        return $this;
    }
    /**
     * Add item to SeatColumn value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatColumnType $item
     * @return \StructType\CabinCompartmentType
     */
    public function addToSeatColumn(\StructType\SeatColumnType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatColumnType) {
            throw new \InvalidArgumentException(sprintf('The SeatColumn property can only contain items of type \StructType\SeatColumnType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatColumn[] = $item;
        return $this;
    }
    /**
     * Get SeatRow value
     * @return \StructType\SeatRowType[]|null
     */
    public function getSeatRow()
    {
        return $this->SeatRow;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatRowForArrayConstraintsFromSetSeatRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinCompartmentTypeSeatRowItem) {
            // validation for constraint: itemType
            if (!$cabinCompartmentTypeSeatRowItem instanceof \StructType\SeatRowType) {
                $invalidValues[] = is_object($cabinCompartmentTypeSeatRowItem) ? get_class($cabinCompartmentTypeSeatRowItem) : sprintf('%s(%s)', gettype($cabinCompartmentTypeSeatRowItem), var_export($cabinCompartmentTypeSeatRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatRow property can only contain items of type \StructType\SeatRowType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatRow value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatRowType[] $seatRow
     * @return \StructType\CabinCompartmentType
     */
    public function setSeatRow(array $seatRow = array())
    {
        // validation for constraint: array
        if ('' !== ($seatRowArrayErrorMessage = self::validateSeatRowForArrayConstraintsFromSetSeatRow($seatRow))) {
            throw new \InvalidArgumentException($seatRowArrayErrorMessage, __LINE__);
        }
        $this->SeatRow = $seatRow;
        return $this;
    }
    /**
     * Add item to SeatRow value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatRowType $item
     * @return \StructType\CabinCompartmentType
     */
    public function addToSeatRow(\StructType\SeatRowType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatRowType) {
            throw new \InvalidArgumentException(sprintf('The SeatRow property can only contain items of type \StructType\SeatRowType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatRow[] = $item;
        return $this;
    }
}
