<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CCApprovalCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Manual Approval code for credit card transactions must be linked to a form of payment
 * @subpackage Structs
 */
class CCApprovalCode extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Currency code used in the credit card transaction
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount charged in the transaction
     * @var int
     */
    public $Amount;
    /**
     * Constructor method for CCApprovalCode
     * @uses CCApprovalCode::set_()
     * @uses CCApprovalCode::setCurrencyCode()
     * @uses CCApprovalCode::setAmount()
     * @param string $_
     * @param string $currencyCode
     * @param int $amount
     */
    public function __construct($_ = null, $currencyCode = null, $amount = null)
    {
        $this
            ->set_($_)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\CCApprovalCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CCApprovalCode
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return int|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\CCApprovalCode
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
}
