<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to a booking or reservation.
 * @subpackage Structs
 */
class BookingRefType extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Existing booking reference Identifier. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BookingID;
    /**
     * The BookingEntity
     * Meta information extracted from the WSDL
     * - documentation: Booking entity Information related to a booking or reservation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BookingEntityType
     */
    public $BookingEntity;
    /**
     * The BookingRefTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Booking Reference Type. Example: 6 (Passenger confirmation number) Encoding Scheme: IATA Padis Codeset - List for data element [1153] Reference Qualifier | Booking Reference Type. Example: 6 (Passenger confirmation number)
     * {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Reference qualifier{/codeListName} {codeListIdentifier}1153{/codeListIdentifier} | A booking reference type
     * - base: BookingRefTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingRefTypeCode;
    /**
     * Constructor method for BookingRefType
     * @uses BookingRefType::setBookingID()
     * @uses BookingRefType::setBookingEntity()
     * @uses BookingRefType::setBookingRefTypeCode()
     * @param string $bookingID
     * @param \StructType\BookingEntityType $bookingEntity
     * @param string $bookingRefTypeCode
     */
    public function __construct($bookingID = null, \StructType\BookingEntityType $bookingEntity = null, $bookingRefTypeCode = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setBookingEntity($bookingEntity)
            ->setBookingRefTypeCode($bookingRefTypeCode);
    }
    /**
     * Get BookingID value
     * @return string
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param string $bookingID
     * @return \StructType\BookingRefType
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingID) && !is_string($bookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get BookingEntity value
     * @return \StructType\BookingEntityType|null
     */
    public function getBookingEntity()
    {
        return $this->BookingEntity;
    }
    /**
     * Set BookingEntity value
     * @param \StructType\BookingEntityType $bookingEntity
     * @return \StructType\BookingRefType
     */
    public function setBookingEntity(\StructType\BookingEntityType $bookingEntity = null)
    {
        $this->BookingEntity = $bookingEntity;
        return $this;
    }
    /**
     * Get BookingRefTypeCode value
     * @return string|null
     */
    public function getBookingRefTypeCode()
    {
        return $this->BookingRefTypeCode;
    }
    /**
     * Set BookingRefTypeCode value
     * @param string $bookingRefTypeCode
     * @return \StructType\BookingRefType
     */
    public function setBookingRefTypeCode($bookingRefTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingRefTypeCode) && !is_string($bookingRefTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingRefTypeCode, true), gettype($bookingRefTypeCode)), __LINE__);
        }
        $this->BookingRefTypeCode = $bookingRefTypeCode;
        return $this;
    }
}
