<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to booking or reservation.
 * @subpackage Structs
 */
class BookingInfoType extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Existing booking reference Identifier. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BookingID;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $Carrier;
    /**
     * The Org
     * Meta information extracted from the WSDL
     * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrgType
     */
    public $Org;
    /**
     * Constructor method for BookingInfoType
     * @uses BookingInfoType::setBookingID()
     * @uses BookingInfoType::setCarrier()
     * @uses BookingInfoType::setOrg()
     * @param string $bookingID
     * @param \StructType\CarrierType $carrier
     * @param \StructType\OrgType $org
     */
    public function __construct($bookingID = null, \StructType\CarrierType $carrier = null, \StructType\OrgType $org = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setCarrier($carrier)
            ->setOrg($org);
    }
    /**
     * Get BookingID value
     * @return string
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param string $bookingID
     * @return \StructType\BookingInfoType
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingID) && !is_string($bookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \StructType\CarrierType $carrier
     * @return \StructType\BookingInfoType
     */
    public function setCarrier(\StructType\CarrierType $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get Org value
     * @return \StructType\OrgType|null
     */
    public function getOrg()
    {
        return $this->Org;
    }
    /**
     * Set Org value
     * @param \StructType\OrgType $org
     * @return \StructType\BookingInfoType
     */
    public function setOrg(\StructType\OrgType $org = null)
    {
        $this->Org = $org;
        return $this;
    }
}
