<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BinaryObjectType StructType
 * Meta information extracted from the WSDL
 * - documentation: A binary object is a sequence of binary digits (bits).
 * @subpackage Structs
 */
class BinaryObjectType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The CharacterSetCode
     * Meta information extracted from the WSDL
     * - documentation: The character set of the binary object if the Multipurpose Internet Mail Extensions (MIME) type is text.
     * - use: optional
     * @var string
     */
    public $CharacterSetCode;
    /**
     * The EncodingCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the decoding algorithm of the binary object.
     * - use: optional
     * @var string
     */
    public $EncodingCode;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - documentation: The filename of the binary object.
     * - use: optional
     * @var string
     */
    public $FileName;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - documentation: The format of the binary content.
     * - use: optional
     * @var string
     */
    public $Format;
    /**
     * The MIME_Code
     * Meta information extracted from the WSDL
     * - documentation: The Multipurpose Internet Mail Extensions (MIME) media type of the binary object.
     * - use: optional
     * @var string
     */
    public $MIME_Code;
    /**
     * The UniformResourceID
     * Meta information extracted from the WSDL
     * - documentation: The Uniform Resource Identifier that identifies where the Binary Object is located.
     * - use: optional
     * @var string
     */
    public $UniformResourceID;
    /**
     * Constructor method for BinaryObjectType
     * @uses BinaryObjectType::set_()
     * @uses BinaryObjectType::setCharacterSetCode()
     * @uses BinaryObjectType::setEncodingCode()
     * @uses BinaryObjectType::setFileName()
     * @uses BinaryObjectType::setFormat()
     * @uses BinaryObjectType::setMIME_Code()
     * @uses BinaryObjectType::setUniformResourceID()
     * @param string $_
     * @param string $characterSetCode
     * @param string $encodingCode
     * @param string $fileName
     * @param string $format
     * @param string $mIME_Code
     * @param string $uniformResourceID
     */
    public function __construct($_ = null, $characterSetCode = null, $encodingCode = null, $fileName = null, $format = null, $mIME_Code = null, $uniformResourceID = null)
    {
        $this
            ->set_($_)
            ->setCharacterSetCode($characterSetCode)
            ->setEncodingCode($encodingCode)
            ->setFileName($fileName)
            ->setFormat($format)
            ->setMIME_Code($mIME_Code)
            ->setUniformResourceID($uniformResourceID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\BinaryObjectType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get CharacterSetCode value
     * @return string|null
     */
    public function getCharacterSetCode()
    {
        return $this->CharacterSetCode;
    }
    /**
     * Set CharacterSetCode value
     * @param string $characterSetCode
     * @return \StructType\BinaryObjectType
     */
    public function setCharacterSetCode($characterSetCode = null)
    {
        // validation for constraint: string
        if (!is_null($characterSetCode) && !is_string($characterSetCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characterSetCode, true), gettype($characterSetCode)), __LINE__);
        }
        $this->CharacterSetCode = $characterSetCode;
        return $this;
    }
    /**
     * Get EncodingCode value
     * @return string|null
     */
    public function getEncodingCode()
    {
        return $this->EncodingCode;
    }
    /**
     * Set EncodingCode value
     * @param string $encodingCode
     * @return \StructType\BinaryObjectType
     */
    public function setEncodingCode($encodingCode = null)
    {
        // validation for constraint: string
        if (!is_null($encodingCode) && !is_string($encodingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encodingCode, true), gettype($encodingCode)), __LINE__);
        }
        $this->EncodingCode = $encodingCode;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\BinaryObjectType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\BinaryObjectType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get MIME_Code value
     * @return string|null
     */
    public function getMIME_Code()
    {
        return $this->MIME_Code;
    }
    /**
     * Set MIME_Code value
     * @param string $mIME_Code
     * @return \StructType\BinaryObjectType
     */
    public function setMIME_Code($mIME_Code = null)
    {
        // validation for constraint: string
        if (!is_null($mIME_Code) && !is_string($mIME_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIME_Code, true), gettype($mIME_Code)), __LINE__);
        }
        $this->MIME_Code = $mIME_Code;
        return $this;
    }
    /**
     * Get UniformResourceID value
     * @return string|null
     */
    public function getUniformResourceID()
    {
        return $this->UniformResourceID;
    }
    /**
     * Set UniformResourceID value
     * @param string $uniformResourceID
     * @return \StructType\BinaryObjectType
     */
    public function setUniformResourceID($uniformResourceID = null)
    {
        // validation for constraint: string
        if (!is_null($uniformResourceID) && !is_string($uniformResourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniformResourceID, true), gettype($uniformResourceID)), __LINE__);
        }
        $this->UniformResourceID = $uniformResourceID;
        return $this;
    }
}
