<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageDisclosureType StructType
 * Meta information extracted from the WSDL
 * - documentation: Disclosure information specifically related to baggage.
 * @subpackage Structs
 */
class BaggageDisclosureType extends AbstractStructBase
{
    /**
     * The BaggageDisclosureID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Bag Disclosure within the message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BaggageDisclosureID;
    /**
     * The RuleTypeCode
     * Meta information extracted from the WSDL
     * - documentation: US Department of Transportation (DOT) Reservation or Disclosure baggage rule. Examples: Y, Disclosure AND US DOT Reservation | Additional BDT to specify the Baggage Disclosure Rule Type.
     * - base: BagDisclosureRuleTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RuleTypeCode;
    /**
     * The BDC
     * Meta information extracted from the WSDL
     * - documentation: A carrier whose baggage allowances and charges apply.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BDC_Type
     */
    public $BDC;
    /**
     * The CheckInChargesInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, additional taxes, fees and charges may be collected at check-in (regionally determined). | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CheckInChargesInd;
    /**
     * The CommercialAgreementID
     * Meta information extracted from the WSDL
     * - documentation: Bilateral agreement identifier E.g. baggage cost, Baggage Determining Carrier, etc. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommercialAgreementID;
    /**
     * The DeferralInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DeferralInd;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DescType[]
     */
    public $Desc;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description text value. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DescText;
    /**
     * The FixedPrePaidInd
     * Meta information extracted from the WSDL
     * - documentation: Allows POA to tell the ORA if the ORA may alter the POA's pre-paid baggage charges. If TRUE, prepaid charge may NOT be altered If FALSE, prepaid charge MAY be altered | An indicator is a list of two mutually exclusive Boolean values
     * that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FixedPrePaidInd;
    /**
     * Constructor method for BaggageDisclosureType
     * @uses BaggageDisclosureType::setBaggageDisclosureID()
     * @uses BaggageDisclosureType::setRuleTypeCode()
     * @uses BaggageDisclosureType::setBDC()
     * @uses BaggageDisclosureType::setCheckInChargesInd()
     * @uses BaggageDisclosureType::setCommercialAgreementID()
     * @uses BaggageDisclosureType::setDeferralInd()
     * @uses BaggageDisclosureType::setDesc()
     * @uses BaggageDisclosureType::setDescText()
     * @uses BaggageDisclosureType::setFixedPrePaidInd()
     * @param string $baggageDisclosureID
     * @param string $ruleTypeCode
     * @param \StructType\BDC_Type $bDC
     * @param bool $checkInChargesInd
     * @param string $commercialAgreementID
     * @param bool $deferralInd
     * @param \StructType\DescType[] $desc
     * @param string[] $descText
     * @param bool $fixedPrePaidInd
     */
    public function __construct($baggageDisclosureID = null, $ruleTypeCode = null, \StructType\BDC_Type $bDC = null, $checkInChargesInd = null, $commercialAgreementID = null, $deferralInd = null, array $desc = array(), array $descText = array(), $fixedPrePaidInd = null)
    {
        $this
            ->setBaggageDisclosureID($baggageDisclosureID)
            ->setRuleTypeCode($ruleTypeCode)
            ->setBDC($bDC)
            ->setCheckInChargesInd($checkInChargesInd)
            ->setCommercialAgreementID($commercialAgreementID)
            ->setDeferralInd($deferralInd)
            ->setDesc($desc)
            ->setDescText($descText)
            ->setFixedPrePaidInd($fixedPrePaidInd);
    }
    /**
     * Get BaggageDisclosureID value
     * @return string
     */
    public function getBaggageDisclosureID()
    {
        return $this->BaggageDisclosureID;
    }
    /**
     * Set BaggageDisclosureID value
     * @param string $baggageDisclosureID
     * @return \StructType\BaggageDisclosureType
     */
    public function setBaggageDisclosureID($baggageDisclosureID = null)
    {
        // validation for constraint: string
        if (!is_null($baggageDisclosureID) && !is_string($baggageDisclosureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageDisclosureID, true), gettype($baggageDisclosureID)), __LINE__);
        }
        $this->BaggageDisclosureID = $baggageDisclosureID;
        return $this;
    }
    /**
     * Get RuleTypeCode value
     * @return string
     */
    public function getRuleTypeCode()
    {
        return $this->RuleTypeCode;
    }
    /**
     * Set RuleTypeCode value
     * @param string $ruleTypeCode
     * @return \StructType\BaggageDisclosureType
     */
    public function setRuleTypeCode($ruleTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleTypeCode) && !is_string($ruleTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleTypeCode, true), gettype($ruleTypeCode)), __LINE__);
        }
        $this->RuleTypeCode = $ruleTypeCode;
        return $this;
    }
    /**
     * Get BDC value
     * @return \StructType\BDC_Type|null
     */
    public function getBDC()
    {
        return $this->BDC;
    }
    /**
     * Set BDC value
     * @param \StructType\BDC_Type $bDC
     * @return \StructType\BaggageDisclosureType
     */
    public function setBDC(\StructType\BDC_Type $bDC = null)
    {
        $this->BDC = $bDC;
        return $this;
    }
    /**
     * Get CheckInChargesInd value
     * @return bool|null
     */
    public function getCheckInChargesInd()
    {
        return $this->CheckInChargesInd;
    }
    /**
     * Set CheckInChargesInd value
     * @param bool $checkInChargesInd
     * @return \StructType\BaggageDisclosureType
     */
    public function setCheckInChargesInd($checkInChargesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkInChargesInd) && !is_bool($checkInChargesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkInChargesInd, true), gettype($checkInChargesInd)), __LINE__);
        }
        $this->CheckInChargesInd = $checkInChargesInd;
        return $this;
    }
    /**
     * Get CommercialAgreementID value
     * @return string|null
     */
    public function getCommercialAgreementID()
    {
        return $this->CommercialAgreementID;
    }
    /**
     * Set CommercialAgreementID value
     * @param string $commercialAgreementID
     * @return \StructType\BaggageDisclosureType
     */
    public function setCommercialAgreementID($commercialAgreementID = null)
    {
        // validation for constraint: string
        if (!is_null($commercialAgreementID) && !is_string($commercialAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commercialAgreementID, true), gettype($commercialAgreementID)), __LINE__);
        }
        $this->CommercialAgreementID = $commercialAgreementID;
        return $this;
    }
    /**
     * Get DeferralInd value
     * @return bool|null
     */
    public function getDeferralInd()
    {
        return $this->DeferralInd;
    }
    /**
     * Set DeferralInd value
     * @param bool $deferralInd
     * @return \StructType\BaggageDisclosureType
     */
    public function setDeferralInd($deferralInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferralInd) && !is_bool($deferralInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferralInd, true), gettype($deferralInd)), __LINE__);
        }
        $this->DeferralInd = $deferralInd;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType[]|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * This method is responsible for validating the values passed to the setDesc method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDesc method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescForArrayConstraintsFromSetDesc(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageDisclosureTypeDescItem) {
            // validation for constraint: itemType
            if (!$baggageDisclosureTypeDescItem instanceof \StructType\DescType) {
                $invalidValues[] = is_object($baggageDisclosureTypeDescItem) ? get_class($baggageDisclosureTypeDescItem) : sprintf('%s(%s)', gettype($baggageDisclosureTypeDescItem), var_export($baggageDisclosureTypeDescItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType[] $desc
     * @return \StructType\BaggageDisclosureType
     */
    public function setDesc(array $desc = array())
    {
        // validation for constraint: array
        if ('' !== ($descArrayErrorMessage = self::validateDescForArrayConstraintsFromSetDesc($desc))) {
            throw new \InvalidArgumentException($descArrayErrorMessage, __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Add item to Desc value
     * @throws \InvalidArgumentException
     * @param \StructType\DescType $item
     * @return \StructType\BaggageDisclosureType
     */
    public function addToDesc(\StructType\DescType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DescType) {
            throw new \InvalidArgumentException(sprintf('The Desc property can only contain items of type \StructType\DescType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Desc[] = $item;
        return $this;
    }
    /**
     * Get DescText value
     * @return string[]|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * This method is responsible for validating the values passed to the setDescText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescTextForArrayConstraintsFromSetDescText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageDisclosureTypeDescTextItem) {
            // validation for constraint: itemType
            if (!is_string($baggageDisclosureTypeDescTextItem)) {
                $invalidValues[] = is_object($baggageDisclosureTypeDescTextItem) ? get_class($baggageDisclosureTypeDescTextItem) : sprintf('%s(%s)', gettype($baggageDisclosureTypeDescTextItem), var_export($baggageDisclosureTypeDescTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DescText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DescText value
     * @throws \InvalidArgumentException
     * @param string[] $descText
     * @return \StructType\BaggageDisclosureType
     */
    public function setDescText(array $descText = array())
    {
        // validation for constraint: array
        if ('' !== ($descTextArrayErrorMessage = self::validateDescTextForArrayConstraintsFromSetDescText($descText))) {
            throw new \InvalidArgumentException($descTextArrayErrorMessage, __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Add item to DescText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BaggageDisclosureType
     */
    public function addToDescText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DescText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DescText[] = $item;
        return $this;
    }
    /**
     * Get FixedPrePaidInd value
     * @return bool|null
     */
    public function getFixedPrePaidInd()
    {
        return $this->FixedPrePaidInd;
    }
    /**
     * Set FixedPrePaidInd value
     * @param bool $fixedPrePaidInd
     * @return \StructType\BaggageDisclosureType
     */
    public function setFixedPrePaidInd($fixedPrePaidInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedPrePaidInd) && !is_bool($fixedPrePaidInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixedPrePaidInd, true), gettype($fixedPrePaidInd)), __LINE__);
        }
        $this->FixedPrePaidInd = $fixedPrePaidInd;
        return $this;
    }
}
