<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageDisclosureListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage disclosure data list definition.
 * @subpackage Structs
 */
class BaggageDisclosureListType extends AbstractStructBase
{
    /**
     * The BaggageDisclosure
     * Meta information extracted from the WSDL
     * - documentation: Disclosure information specifically related to baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\BaggageDisclosureType[]
     */
    public $BaggageDisclosure;
    /**
     * Constructor method for BaggageDisclosureListType
     * @uses BaggageDisclosureListType::setBaggageDisclosure()
     * @param \StructType\BaggageDisclosureType[] $baggageDisclosure
     */
    public function __construct(array $baggageDisclosure = array())
    {
        $this
            ->setBaggageDisclosure($baggageDisclosure);
    }
    /**
     * Get BaggageDisclosure value
     * @return \StructType\BaggageDisclosureType[]
     */
    public function getBaggageDisclosure()
    {
        return $this->BaggageDisclosure;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageDisclosure method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageDisclosure method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageDisclosureForArrayConstraintsFromSetBaggageDisclosure(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageDisclosureListTypeBaggageDisclosureItem) {
            // validation for constraint: itemType
            if (!$baggageDisclosureListTypeBaggageDisclosureItem instanceof \StructType\BaggageDisclosureType) {
                $invalidValues[] = is_object($baggageDisclosureListTypeBaggageDisclosureItem) ? get_class($baggageDisclosureListTypeBaggageDisclosureItem) : sprintf('%s(%s)', gettype($baggageDisclosureListTypeBaggageDisclosureItem), var_export($baggageDisclosureListTypeBaggageDisclosureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageDisclosure property can only contain items of type \StructType\BaggageDisclosureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageDisclosure value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageDisclosureType[] $baggageDisclosure
     * @return \StructType\BaggageDisclosureListType
     */
    public function setBaggageDisclosure(array $baggageDisclosure = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageDisclosureArrayErrorMessage = self::validateBaggageDisclosureForArrayConstraintsFromSetBaggageDisclosure($baggageDisclosure))) {
            throw new \InvalidArgumentException($baggageDisclosureArrayErrorMessage, __LINE__);
        }
        $this->BaggageDisclosure = $baggageDisclosure;
        return $this;
    }
    /**
     * Add item to BaggageDisclosure value
     * @throws \InvalidArgumentException
     * @param \StructType\BaggageDisclosureType $item
     * @return \StructType\BaggageDisclosureListType
     */
    public function addToBaggageDisclosure(\StructType\BaggageDisclosureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaggageDisclosureType) {
            throw new \InvalidArgumentException(sprintf('The BaggageDisclosure property can only contain items of type \StructType\BaggageDisclosureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageDisclosure[] = $item;
        return $this;
    }
}
