<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaggageAssociationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: An association of baggage allowances to passengers.
 * @subpackage Structs
 */
class BaggageAssociationsType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Bag Allowance ID within this message. If there are multiple Allowance ID's, then this should be treated as choice and one baggage item as defined in the referred baggage allowance element can be selected. | An
     * identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $BaggageAllowanceRefID;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The OfferFlightAssociations
     * Meta information extracted from the WSDL
     * - documentation: Offer Flight Associations
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferFlightAssociationsType
     */
    public $OfferFlightAssociations;
    /**
     * Constructor method for BaggageAssociationsType
     * @uses BaggageAssociationsType::setBaggageAllowanceRefID()
     * @uses BaggageAssociationsType::setPaxRefID()
     * @uses BaggageAssociationsType::setOfferFlightAssociations()
     * @param string[] $baggageAllowanceRefID
     * @param string[] $paxRefID
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     */
    public function __construct(array $baggageAllowanceRefID = array(), array $paxRefID = array(), \StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this
            ->setBaggageAllowanceRefID($baggageAllowanceRefID)
            ->setPaxRefID($paxRefID)
            ->setOfferFlightAssociations($offerFlightAssociations);
    }
    /**
     * Get BaggageAllowanceRefID value
     * @return string[]
     */
    public function getBaggageAllowanceRefID()
    {
        return $this->BaggageAllowanceRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setBaggageAllowanceRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaggageAllowanceRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAssociationsTypeBaggageAllowanceRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($baggageAssociationsTypeBaggageAllowanceRefIDItem)) {
                $invalidValues[] = is_object($baggageAssociationsTypeBaggageAllowanceRefIDItem) ? get_class($baggageAssociationsTypeBaggageAllowanceRefIDItem) : sprintf('%s(%s)', gettype($baggageAssociationsTypeBaggageAllowanceRefIDItem), var_export($baggageAssociationsTypeBaggageAllowanceRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string[] $baggageAllowanceRefID
     * @return \StructType\BaggageAssociationsType
     */
    public function setBaggageAllowanceRefID(array $baggageAllowanceRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($baggageAllowanceRefIDArrayErrorMessage = self::validateBaggageAllowanceRefIDForArrayConstraintsFromSetBaggageAllowanceRefID($baggageAllowanceRefID))) {
            throw new \InvalidArgumentException($baggageAllowanceRefIDArrayErrorMessage, __LINE__);
        }
        $this->BaggageAllowanceRefID = $baggageAllowanceRefID;
        return $this;
    }
    /**
     * Add item to BaggageAllowanceRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BaggageAssociationsType
     */
    public function addToBaggageAllowanceRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BaggageAllowanceRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BaggageAllowanceRefID[] = $item;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $baggageAssociationsTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($baggageAssociationsTypePaxRefIDItem)) {
                $invalidValues[] = is_object($baggageAssociationsTypePaxRefIDItem) ? get_class($baggageAssociationsTypePaxRefIDItem) : sprintf('%s(%s)', gettype($baggageAssociationsTypePaxRefIDItem), var_export($baggageAssociationsTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\BaggageAssociationsType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BaggageAssociationsType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get OfferFlightAssociations value
     * @return \StructType\OfferFlightAssociationsType|null
     */
    public function getOfferFlightAssociations()
    {
        return $this->OfferFlightAssociations;
    }
    /**
     * Set OfferFlightAssociations value
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     * @return \StructType\BaggageAssociationsType
     */
    public function setOfferFlightAssociations(\StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this->OfferFlightAssociations = $offerFlightAssociations;
        return $this;
    }
}
