<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagType StructType
 * Meta information extracted from the WSDL
 * - documentation: A piece of luggage associated with a passenger, packed for traveling, and necessary or appropriate in connection with a journey.
 * @subpackage Structs
 */
class BagType extends AbstractStructBase
{
    /**
     * The BagDimension
     * Meta information extracted from the WSDL
     * - documentation: A measurable extent of a particular bag, such as length, or height.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BagDimensionType
     */
    public $BagDimension;
    /**
     * The BagTag
     * Meta information extracted from the WSDL
     * - documentation: A small piece of paper, fabric, plastic or similar material attached to an bag and giving information about it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BagTagType
     */
    public $BagTag;
    /**
     * Constructor method for BagType
     * @uses BagType::setBagDimension()
     * @uses BagType::setBagTag()
     * @param \StructType\BagDimensionType $bagDimension
     * @param \StructType\BagTagType $bagTag
     */
    public function __construct(\StructType\BagDimensionType $bagDimension = null, \StructType\BagTagType $bagTag = null)
    {
        $this
            ->setBagDimension($bagDimension)
            ->setBagTag($bagTag);
    }
    /**
     * Get BagDimension value
     * @return \StructType\BagDimensionType|null
     */
    public function getBagDimension()
    {
        return $this->BagDimension;
    }
    /**
     * Set BagDimension value
     * @param \StructType\BagDimensionType $bagDimension
     * @return \StructType\BagType
     */
    public function setBagDimension(\StructType\BagDimensionType $bagDimension = null)
    {
        $this->BagDimension = $bagDimension;
        return $this;
    }
    /**
     * Get BagTag value
     * @return \StructType\BagTagType|null
     */
    public function getBagTag()
    {
        return $this->BagTag;
    }
    /**
     * Set BagTag value
     * @param \StructType\BagTagType $bagTag
     * @return \StructType\BagType
     */
    public function setBagTag(\StructType\BagTagType $bagTag = null)
    {
        $this->BagTag = $bagTag;
        return $this;
    }
}
