<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagTagType StructType
 * Meta information extracted from the WSDL
 * - documentation: A small piece of paper, fabric, plastic or similar material attached to an bag and giving information about it.
 * @subpackage Structs
 */
class BagTagType extends AbstractStructBase
{
    /**
     * The BagTagID
     * Meta information extracted from the WSDL
     * - documentation: The identifier of bag tag. | The tag identifier of the label document
     * - base: xs:token
     * - length: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{10}
     * @var string
     */
    public $BagTagID;
    /**
     * The IssuingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $IssuingCarrier;
    /**
     * The TagExpediteInd
     * Meta information extracted from the WSDL
     * - documentation: The indicator of whether this is a expedite tag. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TagExpediteInd;
    /**
     * The TagFallbackInd
     * Meta information extracted from the WSDL
     * - documentation: The indicator of whether this is a fallback tag. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TagFallbackInd;
    /**
     * The TagInterlineInd
     * Meta information extracted from the WSDL
     * - documentation: The indicator of whether this is a interline tag. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TagInterlineInd;
    /**
     * Constructor method for BagTagType
     * @uses BagTagType::setBagTagID()
     * @uses BagTagType::setIssuingCarrier()
     * @uses BagTagType::setTagExpediteInd()
     * @uses BagTagType::setTagFallbackInd()
     * @uses BagTagType::setTagInterlineInd()
     * @param string $bagTagID
     * @param \StructType\CarrierType $issuingCarrier
     * @param bool $tagExpediteInd
     * @param bool $tagFallbackInd
     * @param bool $tagInterlineInd
     */
    public function __construct($bagTagID = null, \StructType\CarrierType $issuingCarrier = null, $tagExpediteInd = null, $tagFallbackInd = null, $tagInterlineInd = null)
    {
        $this
            ->setBagTagID($bagTagID)
            ->setIssuingCarrier($issuingCarrier)
            ->setTagExpediteInd($tagExpediteInd)
            ->setTagFallbackInd($tagFallbackInd)
            ->setTagInterlineInd($tagInterlineInd);
    }
    /**
     * Get BagTagID value
     * @return string|null
     */
    public function getBagTagID()
    {
        return $this->BagTagID;
    }
    /**
     * Set BagTagID value
     * @param string $bagTagID
     * @return \StructType\BagTagType
     */
    public function setBagTagID($bagTagID = null)
    {
        // validation for constraint: string
        if (!is_null($bagTagID) && !is_string($bagTagID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bagTagID, true), gettype($bagTagID)), __LINE__);
        }
        // validation for constraint: length(10)
        if (!is_null($bagTagID) && mb_strlen($bagTagID) !== 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 10', mb_strlen($bagTagID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{10})
        if (!is_null($bagTagID) && !preg_match('/[0-9]{10}/', $bagTagID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{10}', var_export($bagTagID, true)), __LINE__);
        }
        $this->BagTagID = $bagTagID;
        return $this;
    }
    /**
     * Get IssuingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getIssuingCarrier()
    {
        return $this->IssuingCarrier;
    }
    /**
     * Set IssuingCarrier value
     * @param \StructType\CarrierType $issuingCarrier
     * @return \StructType\BagTagType
     */
    public function setIssuingCarrier(\StructType\CarrierType $issuingCarrier = null)
    {
        $this->IssuingCarrier = $issuingCarrier;
        return $this;
    }
    /**
     * Get TagExpediteInd value
     * @return bool|null
     */
    public function getTagExpediteInd()
    {
        return $this->TagExpediteInd;
    }
    /**
     * Set TagExpediteInd value
     * @param bool $tagExpediteInd
     * @return \StructType\BagTagType
     */
    public function setTagExpediteInd($tagExpediteInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($tagExpediteInd) && !is_bool($tagExpediteInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tagExpediteInd, true), gettype($tagExpediteInd)), __LINE__);
        }
        $this->TagExpediteInd = $tagExpediteInd;
        return $this;
    }
    /**
     * Get TagFallbackInd value
     * @return bool|null
     */
    public function getTagFallbackInd()
    {
        return $this->TagFallbackInd;
    }
    /**
     * Set TagFallbackInd value
     * @param bool $tagFallbackInd
     * @return \StructType\BagTagType
     */
    public function setTagFallbackInd($tagFallbackInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($tagFallbackInd) && !is_bool($tagFallbackInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tagFallbackInd, true), gettype($tagFallbackInd)), __LINE__);
        }
        $this->TagFallbackInd = $tagFallbackInd;
        return $this;
    }
    /**
     * Get TagInterlineInd value
     * @return bool|null
     */
    public function getTagInterlineInd()
    {
        return $this->TagInterlineInd;
    }
    /**
     * Set TagInterlineInd value
     * @param bool $tagInterlineInd
     * @return \StructType\BagTagType
     */
    public function setTagInterlineInd($tagInterlineInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($tagInterlineInd) && !is_bool($tagInterlineInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tagInterlineInd, true), gettype($tagInterlineInd)), __LINE__);
        }
        $this->TagInterlineInd = $tagInterlineInd;
        return $this;
    }
}
