<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BDC_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: A carrier whose baggage allowances and charges apply.
 * @subpackage Structs
 */
class BDC_Type extends AbstractStructBase
{
    /**
     * The CarrierDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $CarrierDesigCode;
    /**
     * The BagRuleCode
     * Meta information extracted from the WSDL
     * - documentation: US Department of Transportation (DOT) Reservation or Disclosure baggage rule. Examples: Y, Disclosure AND US DOT Reservation | BDT to represent Bag Rule code list.
     * - base: BagRuleCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BagRuleCode;
    /**
     * The BDC_AnalysisResultCode
     * Meta information extracted from the WSDL
     * - documentation: In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code in the AirlineID element. Encoding Scheme: IATA PADIS Code List for data element RES. | Enumeration set for the BDC Analysis Result Code
     * Type BDT. {codeListAgencyIdentifier}PADIS{/codeListAgencyIdentifier} {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}RES{/codeListName} | Additional BDT to specify BDC analysis result code.
     * - base: BDC_AnalysisResultCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BDC_AnalysisResultCode;
    /**
     * The BDC_ReasonText
     * Meta information extracted from the WSDL
     * - documentation: Reason for selection of the Baggage Determining Carrier. Examples: Regulatory (application of regulation or resolution), Deferral (deferral by ORA), Bilateral (bilateral agreement). | Text is a character string such as a finite set
     * of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BDC_ReasonText;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * Constructor method for BDC_Type
     * @uses BDC_Type::setCarrierDesigCode()
     * @uses BDC_Type::setBagRuleCode()
     * @uses BDC_Type::setBDC_AnalysisResultCode()
     * @uses BDC_Type::setBDC_ReasonText()
     * @uses BDC_Type::setCarrierName()
     * @param string $carrierDesigCode
     * @param string $bagRuleCode
     * @param string $bDC_AnalysisResultCode
     * @param string $bDC_ReasonText
     * @param string $carrierName
     */
    public function __construct($carrierDesigCode = null, $bagRuleCode = null, $bDC_AnalysisResultCode = null, $bDC_ReasonText = null, $carrierName = null)
    {
        $this
            ->setCarrierDesigCode($carrierDesigCode)
            ->setBagRuleCode($bagRuleCode)
            ->setBDC_AnalysisResultCode($bDC_AnalysisResultCode)
            ->setBDC_ReasonText($bDC_ReasonText)
            ->setCarrierName($carrierName);
    }
    /**
     * Get CarrierDesigCode value
     * @return string
     */
    public function getCarrierDesigCode()
    {
        return $this->CarrierDesigCode;
    }
    /**
     * Set CarrierDesigCode value
     * @param string $carrierDesigCode
     * @return \StructType\BDC_Type
     */
    public function setCarrierDesigCode($carrierDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierDesigCode) && !is_string($carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierDesigCode, true), gettype($carrierDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($carrierDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($carrierDesigCode, true)), __LINE__);
        }
        $this->CarrierDesigCode = $carrierDesigCode;
        return $this;
    }
    /**
     * Get BagRuleCode value
     * @return string|null
     */
    public function getBagRuleCode()
    {
        return $this->BagRuleCode;
    }
    /**
     * Set BagRuleCode value
     * @param string $bagRuleCode
     * @return \StructType\BDC_Type
     */
    public function setBagRuleCode($bagRuleCode = null)
    {
        // validation for constraint: string
        if (!is_null($bagRuleCode) && !is_string($bagRuleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bagRuleCode, true), gettype($bagRuleCode)), __LINE__);
        }
        $this->BagRuleCode = $bagRuleCode;
        return $this;
    }
    /**
     * Get BDC_AnalysisResultCode value
     * @return string|null
     */
    public function getBDC_AnalysisResultCode()
    {
        return $this->BDC_AnalysisResultCode;
    }
    /**
     * Set BDC_AnalysisResultCode value
     * @param string $bDC_AnalysisResultCode
     * @return \StructType\BDC_Type
     */
    public function setBDC_AnalysisResultCode($bDC_AnalysisResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($bDC_AnalysisResultCode) && !is_string($bDC_AnalysisResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bDC_AnalysisResultCode, true), gettype($bDC_AnalysisResultCode)), __LINE__);
        }
        $this->BDC_AnalysisResultCode = $bDC_AnalysisResultCode;
        return $this;
    }
    /**
     * Get BDC_ReasonText value
     * @return string|null
     */
    public function getBDC_ReasonText()
    {
        return $this->BDC_ReasonText;
    }
    /**
     * Set BDC_ReasonText value
     * @param string $bDC_ReasonText
     * @return \StructType\BDC_Type
     */
    public function setBDC_ReasonText($bDC_ReasonText = null)
    {
        // validation for constraint: string
        if (!is_null($bDC_ReasonText) && !is_string($bDC_ReasonText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bDC_ReasonText, true), gettype($bDC_ReasonText)), __LINE__);
        }
        $this->BDC_ReasonText = $bDC_ReasonText;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\BDC_Type
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
}
