<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailPeriodType StructType
 * Meta information extracted from the WSDL
 * - documentation: Earliest and Latest Period than an option is available or may be used.
 * @subpackage Structs
 */
class AvailPeriodType extends AbstractStructBase
{
    /**
     * The EarliestAvailablePeriodDateTime
     * Meta information extracted from the WSDL
     * - documentation: Offer/ Order term (condition) for the Earliest time an item is Available or May be Used. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of
     * second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EarliestAvailablePeriodDateTime;
    /**
     * The LatestAvailablePeriodDateTime
     * Meta information extracted from the WSDL
     * - documentation: Offer/ Order term (condition) for the Latest time an item is Available or May be Used. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of
     * second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LatestAvailablePeriodDateTime;
    /**
     * Constructor method for AvailPeriodType
     * @uses AvailPeriodType::setEarliestAvailablePeriodDateTime()
     * @uses AvailPeriodType::setLatestAvailablePeriodDateTime()
     * @param string $earliestAvailablePeriodDateTime
     * @param string $latestAvailablePeriodDateTime
     */
    public function __construct($earliestAvailablePeriodDateTime = null, $latestAvailablePeriodDateTime = null)
    {
        $this
            ->setEarliestAvailablePeriodDateTime($earliestAvailablePeriodDateTime)
            ->setLatestAvailablePeriodDateTime($latestAvailablePeriodDateTime);
    }
    /**
     * Get EarliestAvailablePeriodDateTime value
     * @return string|null
     */
    public function getEarliestAvailablePeriodDateTime()
    {
        return $this->EarliestAvailablePeriodDateTime;
    }
    /**
     * Set EarliestAvailablePeriodDateTime value
     * @param string $earliestAvailablePeriodDateTime
     * @return \StructType\AvailPeriodType
     */
    public function setEarliestAvailablePeriodDateTime($earliestAvailablePeriodDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($earliestAvailablePeriodDateTime) && !is_string($earliestAvailablePeriodDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestAvailablePeriodDateTime, true), gettype($earliestAvailablePeriodDateTime)), __LINE__);
        }
        $this->EarliestAvailablePeriodDateTime = $earliestAvailablePeriodDateTime;
        return $this;
    }
    /**
     * Get LatestAvailablePeriodDateTime value
     * @return string|null
     */
    public function getLatestAvailablePeriodDateTime()
    {
        return $this->LatestAvailablePeriodDateTime;
    }
    /**
     * Set LatestAvailablePeriodDateTime value
     * @param string $latestAvailablePeriodDateTime
     * @return \StructType\AvailPeriodType
     */
    public function setLatestAvailablePeriodDateTime($latestAvailablePeriodDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($latestAvailablePeriodDateTime) && !is_string($latestAvailablePeriodDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestAvailablePeriodDateTime, true), gettype($latestAvailablePeriodDateTime)), __LINE__);
        }
        $this->LatestAvailablePeriodDateTime = $latestAvailablePeriodDateTime;
        return $this;
    }
}
