<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for app StructType
 * @subpackage Structs
 */
class App extends AbstractStructBase
{
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $version;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $language;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for app
     * @uses App::setVersion()
     * @uses App::setLanguage()
     * @uses App::set_()
     * @param string $version
     * @param string $language
     * @param string $_
     */
    public function __construct($version = null, $language = null, $_ = null)
    {
        $this
            ->setVersion($version)
            ->setLanguage($language)
            ->set_($_);
    }
    /**
     * Get version value
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\App
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\App
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\App
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
