<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amount StructType
 * Meta information extracted from the WSDL
 * - documentation: Base Fare Amount as originally filed. | The total fare amount including taxes of a fare alternative.
 * @subpackage Structs
 */
class Amount extends AbstractStructBase
{
    /**
     * The _
     * @var int
     */
    public $_;
    /**
     * The BulkMask
     * Meta information extracted from the WSDL
     * - documentation: This mask applies to IT/BT tickets where the masked value may be "BT" or "IT" instead of the true amount.Note: this mask is ALWAYS used for the passenger ticket image.
     * @var string
     */
    public $BulkMask;
    /**
     * Constructor method for Amount
     * @uses Amount::set_()
     * @uses Amount::setBulkMask()
     * @param int $_
     * @param string $bulkMask
     */
    public function __construct($_ = null, $bulkMask = null)
    {
        $this
            ->set_($_)
            ->setBulkMask($bulkMask);
    }
    /**
     * Get _ value
     * @return int|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param int $_
     * @return \StructType\Amount
     */
    public function set_($_ = null)
    {
        // validation for constraint: int
        if (!is_null($_) && !(is_int($_) || ctype_digit($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get BulkMask value
     * @return string|null
     */
    public function getBulkMask()
    {
        return $this->BulkMask;
    }
    /**
     * Set BulkMask value
     * @param string $bulkMask
     * @return \StructType\Amount
     */
    public function setBulkMask($bulkMask = null)
    {
        // validation for constraint: string
        if (!is_null($bulkMask) && !is_string($bulkMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkMask, true), gettype($bulkMask)), __LINE__);
        }
        $this->BulkMask = $bulkMask;
        return $this;
    }
}
