<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amex StructType
 * Meta information extracted from the WSDL
 * - documentation: AMEX BTA/IBTA data
 * @subpackage Structs
 */
class Amex extends AbstractStructBase
{
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - documentation: Attribute identifying the type of Amex IBTA codes
     * @var string
     */
    public $ProductType;
    /**
     * The ReferenceData
     * Meta information extracted from the WSDL
     * - documentation: Card scheme specified reference data values
     * @var string
     */
    public $ReferenceData;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Customer Reference Number Values 01 - 07
     * @var string
     */
    public $Number;
    /**
     * Constructor method for Amex
     * @uses Amex::setProductType()
     * @uses Amex::setReferenceData()
     * @uses Amex::setNumber()
     * @param string $productType
     * @param string $referenceData
     * @param string $number
     */
    public function __construct($productType = null, $referenceData = null, $number = null)
    {
        $this
            ->setProductType($productType)
            ->setReferenceData($referenceData)
            ->setNumber($number);
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\Amex
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ReferenceData value
     * @return string|null
     */
    public function getReferenceData()
    {
        return $this->ReferenceData;
    }
    /**
     * Set ReferenceData value
     * @param string $referenceData
     * @return \StructType\Amex
     */
    public function setReferenceData($referenceData = null)
    {
        // validation for constraint: string
        if (!is_null($referenceData) && !is_string($referenceData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceData, true), gettype($referenceData)), __LINE__);
        }
        $this->ReferenceData = $referenceData;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\Amex
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
}
