<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllianceCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Filtering criteria based on Alliance.
 * @subpackage Structs
 */
class AllianceCriteriaType extends AbstractStructBase
{
    /**
     * The Alliance
     * Meta information extracted from the WSDL
     * - documentation: Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AllianceType
     */
    public $Alliance;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for AllianceCriteriaType
     * @uses AllianceCriteriaType::setAlliance()
     * @uses AllianceCriteriaType::setPrefLevel()
     * @param \StructType\AllianceType $alliance
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct(\StructType\AllianceType $alliance = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setAlliance($alliance)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get Alliance value
     * @return \StructType\AllianceType
     */
    public function getAlliance()
    {
        return $this->Alliance;
    }
    /**
     * Set Alliance value
     * @param \StructType\AllianceType $alliance
     * @return \StructType\AllianceCriteriaType
     */
    public function setAlliance(\StructType\AllianceType $alliance = null)
    {
        $this->Alliance = $alliance;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\AllianceCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
