<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineProfileResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Airline Profile response message
 * @subpackage Structs
 */
class AirlineProfileResponseType extends AbstractStructBase
{
    /**
     * The AirlineProfile
     * Meta information extracted from the WSDL
     * - documentation: Distribution profile of an airline which describes which types of shopping requests may be processed by a particular carrier.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AirlineProfileType[]
     */
    public $AirlineProfile;
    /**
     * The KeyValueProperty
     * Meta information extracted from the WSDL
     * - documentation: Contextual information to further describe something using a key-value pair.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePropertyType[]
     */
    public $KeyValueProperty;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for AirlineProfileResponseType
     * @uses AirlineProfileResponseType::setAirlineProfile()
     * @uses AirlineProfileResponseType::setKeyValueProperty()
     * @uses AirlineProfileResponseType::setWarning()
     * @param \StructType\AirlineProfileType[] $airlineProfile
     * @param \StructType\KeyValuePropertyType[] $keyValueProperty
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(array $airlineProfile = array(), array $keyValueProperty = array(), array $warning = array())
    {
        $this
            ->setAirlineProfile($airlineProfile)
            ->setKeyValueProperty($keyValueProperty)
            ->setWarning($warning);
    }
    /**
     * Get AirlineProfile value
     * @return \StructType\AirlineProfileType[]
     */
    public function getAirlineProfile()
    {
        return $this->AirlineProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineProfileForArrayConstraintsFromSetAirlineProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileResponseTypeAirlineProfileItem) {
            // validation for constraint: itemType
            if (!$airlineProfileResponseTypeAirlineProfileItem instanceof \StructType\AirlineProfileType) {
                $invalidValues[] = is_object($airlineProfileResponseTypeAirlineProfileItem) ? get_class($airlineProfileResponseTypeAirlineProfileItem) : sprintf('%s(%s)', gettype($airlineProfileResponseTypeAirlineProfileItem), var_export($airlineProfileResponseTypeAirlineProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineProfile property can only contain items of type \StructType\AirlineProfileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineProfileType[] $airlineProfile
     * @return \StructType\AirlineProfileResponseType
     */
    public function setAirlineProfile(array $airlineProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineProfileArrayErrorMessage = self::validateAirlineProfileForArrayConstraintsFromSetAirlineProfile($airlineProfile))) {
            throw new \InvalidArgumentException($airlineProfileArrayErrorMessage, __LINE__);
        }
        $this->AirlineProfile = $airlineProfile;
        return $this;
    }
    /**
     * Add item to AirlineProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineProfileType $item
     * @return \StructType\AirlineProfileResponseType
     */
    public function addToAirlineProfile(\StructType\AirlineProfileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineProfileType) {
            throw new \InvalidArgumentException(sprintf('The AirlineProfile property can only contain items of type \StructType\AirlineProfileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineProfile[] = $item;
        return $this;
    }
    /**
     * Get KeyValueProperty value
     * @return \StructType\KeyValuePropertyType[]|null
     */
    public function getKeyValueProperty()
    {
        return $this->KeyValueProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setKeyValueProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyValueProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyValuePropertyForArrayConstraintsFromSetKeyValueProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileResponseTypeKeyValuePropertyItem) {
            // validation for constraint: itemType
            if (!$airlineProfileResponseTypeKeyValuePropertyItem instanceof \StructType\KeyValuePropertyType) {
                $invalidValues[] = is_object($airlineProfileResponseTypeKeyValuePropertyItem) ? get_class($airlineProfileResponseTypeKeyValuePropertyItem) : sprintf('%s(%s)', gettype($airlineProfileResponseTypeKeyValuePropertyItem), var_export($airlineProfileResponseTypeKeyValuePropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeyValueProperty property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeyValueProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType[] $keyValueProperty
     * @return \StructType\AirlineProfileResponseType
     */
    public function setKeyValueProperty(array $keyValueProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($keyValuePropertyArrayErrorMessage = self::validateKeyValuePropertyForArrayConstraintsFromSetKeyValueProperty($keyValueProperty))) {
            throw new \InvalidArgumentException($keyValuePropertyArrayErrorMessage, __LINE__);
        }
        $this->KeyValueProperty = $keyValueProperty;
        return $this;
    }
    /**
     * Add item to KeyValueProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType $item
     * @return \StructType\AirlineProfileResponseType
     */
    public function addToKeyValueProperty(\StructType\KeyValuePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePropertyType) {
            throw new \InvalidArgumentException(sprintf('The KeyValueProperty property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->KeyValueProperty[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineProfileResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$airlineProfileResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($airlineProfileResponseTypeWarningItem) ? get_class($airlineProfileResponseTypeWarningItem) : sprintf('%s(%s)', gettype($airlineProfileResponseTypeWarningItem), var_export($airlineProfileResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\AirlineProfileResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\AirlineProfileResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
