<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOfferItemsType StructType
 * Meta information extracted from the WSDL
 * - documentation: An action to request new Added Offer Items for the specified Order. If used in conjunction with a 'Delete' function, the intention is to replace the deleted item with whatever has been requested in this Add function's shopping query.
 * @subpackage Structs
 */
class AddOfferItemsType extends AbstractStructBase
{
    /**
     * The FlightRequest
     * Meta information extracted from the WSDL
     * - documentation: Flight Request
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FlightRequestType
     */
    public $FlightRequest;
    /**
     * The FlightRelatedCriteria
     * Meta information extracted from the WSDL
     * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FlightRelatedCriteriaType
     */
    public $FlightRelatedCriteria;
    /**
     * The OrderCriteria
     * Meta information extracted from the WSDL
     * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderCriteriaType
     */
    public $OrderCriteria;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for AddOfferItemsType
     * @uses AddOfferItemsType::setFlightRequest()
     * @uses AddOfferItemsType::setFlightRelatedCriteria()
     * @uses AddOfferItemsType::setOrderCriteria()
     * @uses AddOfferItemsType::setPaxList()
     * @uses AddOfferItemsType::setResponseParameters()
     * @param \StructType\FlightRequestType $flightRequest
     * @param \StructType\FlightRelatedCriteriaType $flightRelatedCriteria
     * @param \StructType\OrderCriteriaType $orderCriteria
     * @param \StructType\PaxListType $paxList
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\FlightRequestType $flightRequest = null, \StructType\FlightRelatedCriteriaType $flightRelatedCriteria = null, \StructType\OrderCriteriaType $orderCriteria = null, \StructType\PaxListType $paxList = null, \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setFlightRequest($flightRequest)
            ->setFlightRelatedCriteria($flightRelatedCriteria)
            ->setOrderCriteria($orderCriteria)
            ->setPaxList($paxList)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get FlightRequest value
     * @return \StructType\FlightRequestType
     */
    public function getFlightRequest()
    {
        return $this->FlightRequest;
    }
    /**
     * Set FlightRequest value
     * @param \StructType\FlightRequestType $flightRequest
     * @return \StructType\AddOfferItemsType
     */
    public function setFlightRequest(\StructType\FlightRequestType $flightRequest = null)
    {
        $this->FlightRequest = $flightRequest;
        return $this;
    }
    /**
     * Get FlightRelatedCriteria value
     * @return \StructType\FlightRelatedCriteriaType|null
     */
    public function getFlightRelatedCriteria()
    {
        return $this->FlightRelatedCriteria;
    }
    /**
     * Set FlightRelatedCriteria value
     * @param \StructType\FlightRelatedCriteriaType $flightRelatedCriteria
     * @return \StructType\AddOfferItemsType
     */
    public function setFlightRelatedCriteria(\StructType\FlightRelatedCriteriaType $flightRelatedCriteria = null)
    {
        $this->FlightRelatedCriteria = $flightRelatedCriteria;
        return $this;
    }
    /**
     * Get OrderCriteria value
     * @return \StructType\OrderCriteriaType|null
     */
    public function getOrderCriteria()
    {
        return $this->OrderCriteria;
    }
    /**
     * Set OrderCriteria value
     * @param \StructType\OrderCriteriaType $orderCriteria
     * @return \StructType\AddOfferItemsType
     */
    public function setOrderCriteria(\StructType\OrderCriteriaType $orderCriteria = null)
    {
        $this->OrderCriteria = $orderCriteria;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\AddOfferItemsType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\AddOfferItemsType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
