<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingPriceAndFareDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for Price and Fare detail information.
 * @subpackage Structs
 */
class AccountingPriceAndFareDetailsType extends AbstractStructBase
{
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccountedFareDetailType[]
     */
    public $FareDetail;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: An amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPriceType
     */
    public $Price;
    /**
     * Constructor method for AccountingPriceAndFareDetailsType
     * @uses AccountingPriceAndFareDetailsType::setFareDetail()
     * @uses AccountingPriceAndFareDetailsType::setPrice()
     * @param \StructType\AccountedFareDetailType[] $fareDetail
     * @param \StructType\AccountedPriceType $price
     */
    public function __construct(array $fareDetail = array(), \StructType\AccountedPriceType $price = null)
    {
        $this
            ->setFareDetail($fareDetail)
            ->setPrice($price);
    }
    /**
     * Get FareDetail value
     * @return \StructType\AccountedFareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountingPriceAndFareDetailsTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$accountingPriceAndFareDetailsTypeFareDetailItem instanceof \StructType\AccountedFareDetailType) {
                $invalidValues[] = is_object($accountingPriceAndFareDetailsTypeFareDetailItem) ? get_class($accountingPriceAndFareDetailsTypeFareDetailItem) : sprintf('%s(%s)', gettype($accountingPriceAndFareDetailsTypeFareDetailItem), var_export($accountingPriceAndFareDetailsTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\AccountedFareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedFareDetailType[] $fareDetail
     * @return \StructType\AccountingPriceAndFareDetailsType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedFareDetailType $item
     * @return \StructType\AccountingPriceAndFareDetailsType
     */
    public function addToFareDetail(\StructType\AccountedFareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountedFareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\AccountedFareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\AccountedPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\AccountedPriceType $price
     * @return \StructType\AccountingPriceAndFareDetailsType
     */
    public function setPrice(\StructType\AccountedPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
