<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingFarePriceTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: An additional specified fare pricing such as 'Net' and 'Filed'. For 'Sell' or public amounts, use the Price in Fare Details.
 * @subpackage Structs
 */
class AccountingFarePriceTypeType extends AbstractStructBase
{
    /**
     * The FarePriceTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the fare price provided is a filed amount, net amount, or a sell amount. | A fare price type.
     * - base: FarePriceTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FarePriceTypeCode;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: An amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AccountedPriceType
     */
    public $Price;
    /**
     * Constructor method for AccountingFarePriceTypeType
     * @uses AccountingFarePriceTypeType::setFarePriceTypeCode()
     * @uses AccountingFarePriceTypeType::setPrice()
     * @param string $farePriceTypeCode
     * @param \StructType\AccountedPriceType $price
     */
    public function __construct($farePriceTypeCode = null, \StructType\AccountedPriceType $price = null)
    {
        $this
            ->setFarePriceTypeCode($farePriceTypeCode)
            ->setPrice($price);
    }
    /**
     * Get FarePriceTypeCode value
     * @return string
     */
    public function getFarePriceTypeCode()
    {
        return $this->FarePriceTypeCode;
    }
    /**
     * Set FarePriceTypeCode value
     * @param string $farePriceTypeCode
     * @return \StructType\AccountingFarePriceTypeType
     */
    public function setFarePriceTypeCode($farePriceTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($farePriceTypeCode) && !is_string($farePriceTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($farePriceTypeCode, true), gettype($farePriceTypeCode)), __LINE__);
        }
        $this->FarePriceTypeCode = $farePriceTypeCode;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\AccountedPriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\AccountedPriceType $price
     * @return \StructType\AccountingFarePriceTypeType
     */
    public function setPrice(\StructType\AccountedPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
