<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: An amount of money expected, required, or given in payment for something.
 * @subpackage Structs
 */
class AccountedPriceType extends AbstractStructBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Total Base Fare Amount. Example: 200000
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $BaseAmount;
    /**
     * The BaseAmountGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the Base Amount of an offer item is guaranteed. In the absence of the Base Amount guarantee time limit, the Base Amount is not guaranteed. Upon expiry, the Base Amount may no longer be guaranteed and either a new
     * shopping process should begin, or the offer should be repriced resulting in a new Offer. Should the Base Amount guarantee time limit extend beyond Order creation, the remaining length of time persists into the corresponding Order Item. The airline
     * can increase the remaining length of time beyond the original time limit should they wish to. This field should only be used when the Airline indicates that a Price Guarantee is available. | A date time identifies a date and time of day to various
     * common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BaseAmountGuaranteeTimeLimitDateTime;
    /**
     * The CurConversion
     * Meta information extracted from the WSDL
     * - documentation: The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurConversionType[]
     */
    public $CurConversion;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - documentation: Deduction from the price amount, made in advance of its payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DiscountType
     */
    public $Discount;
    /**
     * The EquivAmount
     * Meta information extracted from the WSDL
     * - documentation: The entire amount of transaction stated in the local currency at the point of sale, or the currency as defined by the Currency Indicator Code.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $EquivAmount;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FeeType[]
     */
    public $Fee;
    /**
     * The LoyaltyUnitAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount specified in loyalty units. Note: the 'Currency Code' sup for this BDT should not be populated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyAmountType
     */
    public $LoyaltyUnitAmount;
    /**
     * The LoyaltyUnitName
     * Meta information extracted from the WSDL
     * - documentation: The name of the loyalty unit used by the loyalty unit amount (e.g. miles or points). | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoyaltyUnitName;
    /**
     * The Markup
     * Meta information extracted from the WSDL
     * - documentation: Defines the reason for the markup added by an airline as part of the offer reported as calculation detail. The amount added to the cost price of goods to cover overhead and profit. [Oxford]
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarkupType[]
     */
    public $Markup;
    /**
     * The MaskedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator to advise the Seller if the price will be masked to the Customer | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MaskedInd;
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a usual charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SurchargeType[]
     */
    public $Surcharge;
    /**
     * The TaxSummary
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * The VAT_BreakdownElement
     * Meta information extracted from the WSDL
     * - documentation: Optional Information relating to VAT if an amount is reported gross. The information provided allows the VAT to be determined from the gross value amount.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VAT_BreakdownElementType[]
     */
    public $VAT_BreakdownElement;
    /**
     * Constructor method for AccountedPriceType
     * @uses AccountedPriceType::setBaseAmount()
     * @uses AccountedPriceType::setBaseAmountGuaranteeTimeLimitDateTime()
     * @uses AccountedPriceType::setCurConversion()
     * @uses AccountedPriceType::setDiscount()
     * @uses AccountedPriceType::setEquivAmount()
     * @uses AccountedPriceType::setFee()
     * @uses AccountedPriceType::setLoyaltyUnitAmount()
     * @uses AccountedPriceType::setLoyaltyUnitName()
     * @uses AccountedPriceType::setMarkup()
     * @uses AccountedPriceType::setMaskedInd()
     * @uses AccountedPriceType::setSurcharge()
     * @uses AccountedPriceType::setTaxSummary()
     * @uses AccountedPriceType::setTotalAmount()
     * @uses AccountedPriceType::setVAT_BreakdownElement()
     * @param \StructType\AmountType $baseAmount
     * @param string $baseAmountGuaranteeTimeLimitDateTime
     * @param \StructType\CurConversionType[] $curConversion
     * @param \StructType\DiscountType $discount
     * @param \StructType\AmountType $equivAmount
     * @param \StructType\FeeType[] $fee
     * @param \StructType\LoyaltyAmountType $loyaltyUnitAmount
     * @param string $loyaltyUnitName
     * @param \StructType\MarkupType[] $markup
     * @param bool $maskedInd
     * @param \StructType\SurchargeType[] $surcharge
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @param \StructType\AmountType $totalAmount
     * @param \StructType\VAT_BreakdownElementType[] $vAT_BreakdownElement
     */
    public function __construct(\StructType\AmountType $baseAmount = null, $baseAmountGuaranteeTimeLimitDateTime = null, array $curConversion = array(), \StructType\DiscountType $discount = null, \StructType\AmountType $equivAmount = null, array $fee = array(), \StructType\LoyaltyAmountType $loyaltyUnitAmount = null, $loyaltyUnitName = null, array $markup = array(), $maskedInd = null, array $surcharge = array(), array $taxSummary = array(), \StructType\AmountType $totalAmount = null, array $vAT_BreakdownElement = array())
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setBaseAmountGuaranteeTimeLimitDateTime($baseAmountGuaranteeTimeLimitDateTime)
            ->setCurConversion($curConversion)
            ->setDiscount($discount)
            ->setEquivAmount($equivAmount)
            ->setFee($fee)
            ->setLoyaltyUnitAmount($loyaltyUnitAmount)
            ->setLoyaltyUnitName($loyaltyUnitName)
            ->setMarkup($markup)
            ->setMaskedInd($maskedInd)
            ->setSurcharge($surcharge)
            ->setTaxSummary($taxSummary)
            ->setTotalAmount($totalAmount)
            ->setVAT_BreakdownElement($vAT_BreakdownElement);
    }
    /**
     * Get BaseAmount value
     * @return \StructType\AmountType|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param \StructType\AmountType $baseAmount
     * @return \StructType\AccountedPriceType
     */
    public function setBaseAmount(\StructType\AmountType $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get BaseAmountGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getBaseAmountGuaranteeTimeLimitDateTime()
    {
        return $this->BaseAmountGuaranteeTimeLimitDateTime;
    }
    /**
     * Set BaseAmountGuaranteeTimeLimitDateTime value
     * @param string $baseAmountGuaranteeTimeLimitDateTime
     * @return \StructType\AccountedPriceType
     */
    public function setBaseAmountGuaranteeTimeLimitDateTime($baseAmountGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($baseAmountGuaranteeTimeLimitDateTime) && !is_string($baseAmountGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseAmountGuaranteeTimeLimitDateTime, true), gettype($baseAmountGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->BaseAmountGuaranteeTimeLimitDateTime = $baseAmountGuaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get CurConversion value
     * @return \StructType\CurConversionType[]|null
     */
    public function getCurConversion()
    {
        return $this->CurConversion;
    }
    /**
     * This method is responsible for validating the values passed to the setCurConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurConversionForArrayConstraintsFromSetCurConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPriceTypeCurConversionItem) {
            // validation for constraint: itemType
            if (!$accountedPriceTypeCurConversionItem instanceof \StructType\CurConversionType) {
                $invalidValues[] = is_object($accountedPriceTypeCurConversionItem) ? get_class($accountedPriceTypeCurConversionItem) : sprintf('%s(%s)', gettype($accountedPriceTypeCurConversionItem), var_export($accountedPriceTypeCurConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType[] $curConversion
     * @return \StructType\AccountedPriceType
     */
    public function setCurConversion(array $curConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($curConversionArrayErrorMessage = self::validateCurConversionForArrayConstraintsFromSetCurConversion($curConversion))) {
            throw new \InvalidArgumentException($curConversionArrayErrorMessage, __LINE__);
        }
        $this->CurConversion = $curConversion;
        return $this;
    }
    /**
     * Add item to CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType $item
     * @return \StructType\AccountedPriceType
     */
    public function addToCurConversion(\StructType\CurConversionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurConversionType) {
            throw new \InvalidArgumentException(sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurConversion[] = $item;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\DiscountType|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\DiscountType $discount
     * @return \StructType\AccountedPriceType
     */
    public function setDiscount(\StructType\DiscountType $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get EquivAmount value
     * @return \StructType\AmountType|null
     */
    public function getEquivAmount()
    {
        return $this->EquivAmount;
    }
    /**
     * Set EquivAmount value
     * @param \StructType\AmountType $equivAmount
     * @return \StructType\AccountedPriceType
     */
    public function setEquivAmount(\StructType\AmountType $equivAmount = null)
    {
        $this->EquivAmount = $equivAmount;
        return $this;
    }
    /**
     * Get Fee value
     * @return \StructType\FeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPriceTypeFeeItem) {
            // validation for constraint: itemType
            if (!$accountedPriceTypeFeeItem instanceof \StructType\FeeType) {
                $invalidValues[] = is_object($accountedPriceTypeFeeItem) ? get_class($accountedPriceTypeFeeItem) : sprintf('%s(%s)', gettype($accountedPriceTypeFeeItem), var_export($accountedPriceTypeFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \StructType\FeeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType[] $fee
     * @return \StructType\AccountedPriceType
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType $item
     * @return \StructType\AccountedPriceType
     */
    public function addToFee(\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type \StructType\FeeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyUnitAmount value
     * @return \StructType\LoyaltyAmountType|null
     */
    public function getLoyaltyUnitAmount()
    {
        return $this->LoyaltyUnitAmount;
    }
    /**
     * Set LoyaltyUnitAmount value
     * @param \StructType\LoyaltyAmountType $loyaltyUnitAmount
     * @return \StructType\AccountedPriceType
     */
    public function setLoyaltyUnitAmount(\StructType\LoyaltyAmountType $loyaltyUnitAmount = null)
    {
        $this->LoyaltyUnitAmount = $loyaltyUnitAmount;
        return $this;
    }
    /**
     * Get LoyaltyUnitName value
     * @return string|null
     */
    public function getLoyaltyUnitName()
    {
        return $this->LoyaltyUnitName;
    }
    /**
     * Set LoyaltyUnitName value
     * @param string $loyaltyUnitName
     * @return \StructType\AccountedPriceType
     */
    public function setLoyaltyUnitName($loyaltyUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyUnitName) && !is_string($loyaltyUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyUnitName, true), gettype($loyaltyUnitName)), __LINE__);
        }
        $this->LoyaltyUnitName = $loyaltyUnitName;
        return $this;
    }
    /**
     * Get Markup value
     * @return \StructType\MarkupType[]|null
     */
    public function getMarkup()
    {
        return $this->Markup;
    }
    /**
     * This method is responsible for validating the values passed to the setMarkup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarkup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarkupForArrayConstraintsFromSetMarkup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPriceTypeMarkupItem) {
            // validation for constraint: itemType
            if (!$accountedPriceTypeMarkupItem instanceof \StructType\MarkupType) {
                $invalidValues[] = is_object($accountedPriceTypeMarkupItem) ? get_class($accountedPriceTypeMarkupItem) : sprintf('%s(%s)', gettype($accountedPriceTypeMarkupItem), var_export($accountedPriceTypeMarkupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Markup property can only contain items of type \StructType\MarkupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Markup value
     * @throws \InvalidArgumentException
     * @param \StructType\MarkupType[] $markup
     * @return \StructType\AccountedPriceType
     */
    public function setMarkup(array $markup = array())
    {
        // validation for constraint: array
        if ('' !== ($markupArrayErrorMessage = self::validateMarkupForArrayConstraintsFromSetMarkup($markup))) {
            throw new \InvalidArgumentException($markupArrayErrorMessage, __LINE__);
        }
        $this->Markup = $markup;
        return $this;
    }
    /**
     * Add item to Markup value
     * @throws \InvalidArgumentException
     * @param \StructType\MarkupType $item
     * @return \StructType\AccountedPriceType
     */
    public function addToMarkup(\StructType\MarkupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarkupType) {
            throw new \InvalidArgumentException(sprintf('The Markup property can only contain items of type \StructType\MarkupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Markup[] = $item;
        return $this;
    }
    /**
     * Get MaskedInd value
     * @return bool|null
     */
    public function getMaskedInd()
    {
        return $this->MaskedInd;
    }
    /**
     * Set MaskedInd value
     * @param bool $maskedInd
     * @return \StructType\AccountedPriceType
     */
    public function setMaskedInd($maskedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maskedInd) && !is_bool($maskedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($maskedInd, true), gettype($maskedInd)), __LINE__);
        }
        $this->MaskedInd = $maskedInd;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return \StructType\SurchargeType[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPriceTypeSurchargeItem) {
            // validation for constraint: itemType
            if (!$accountedPriceTypeSurchargeItem instanceof \StructType\SurchargeType) {
                $invalidValues[] = is_object($accountedPriceTypeSurchargeItem) ? get_class($accountedPriceTypeSurchargeItem) : sprintf('%s(%s)', gettype($accountedPriceTypeSurchargeItem), var_export($accountedPriceTypeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType[] $surcharge
     * @return \StructType\AccountedPriceType
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType $item
     * @return \StructType\AccountedPriceType
     */
    public function addToSurcharge(\StructType\SurchargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SurchargeType) {
            throw new \InvalidArgumentException(sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \StructType\TaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSummaryForArrayConstraintsFromSetTaxSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPriceTypeTaxSummaryItem) {
            // validation for constraint: itemType
            if (!$accountedPriceTypeTaxSummaryItem instanceof \StructType\TaxSummaryType) {
                $invalidValues[] = is_object($accountedPriceTypeTaxSummaryItem) ? get_class($accountedPriceTypeTaxSummaryItem) : sprintf('%s(%s)', gettype($accountedPriceTypeTaxSummaryItem), var_export($accountedPriceTypeTaxSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @return \StructType\AccountedPriceType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSummaryArrayErrorMessage = self::validateTaxSummaryForArrayConstraintsFromSetTaxSummary($taxSummary))) {
            throw new \InvalidArgumentException($taxSummaryArrayErrorMessage, __LINE__);
        }
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType $item
     * @return \StructType\AccountedPriceType
     */
    public function addToTaxSummary(\StructType\TaxSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxSummaryType) {
            throw new \InvalidArgumentException(sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\AccountedPriceType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get VAT_BreakdownElement value
     * @return \StructType\VAT_BreakdownElementType[]|null
     */
    public function getVAT_BreakdownElement()
    {
        return $this->VAT_BreakdownElement;
    }
    /**
     * This method is responsible for validating the values passed to the setVAT_BreakdownElement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVAT_BreakdownElement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVAT_BreakdownElementForArrayConstraintsFromSetVAT_BreakdownElement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedPriceTypeVAT_BreakdownElementItem) {
            // validation for constraint: itemType
            if (!$accountedPriceTypeVAT_BreakdownElementItem instanceof \StructType\VAT_BreakdownElementType) {
                $invalidValues[] = is_object($accountedPriceTypeVAT_BreakdownElementItem) ? get_class($accountedPriceTypeVAT_BreakdownElementItem) : sprintf('%s(%s)', gettype($accountedPriceTypeVAT_BreakdownElementItem), var_export($accountedPriceTypeVAT_BreakdownElementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VAT_BreakdownElement property can only contain items of type \StructType\VAT_BreakdownElementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VAT_BreakdownElement value
     * @throws \InvalidArgumentException
     * @param \StructType\VAT_BreakdownElementType[] $vAT_BreakdownElement
     * @return \StructType\AccountedPriceType
     */
    public function setVAT_BreakdownElement(array $vAT_BreakdownElement = array())
    {
        // validation for constraint: array
        if ('' !== ($vAT_BreakdownElementArrayErrorMessage = self::validateVAT_BreakdownElementForArrayConstraintsFromSetVAT_BreakdownElement($vAT_BreakdownElement))) {
            throw new \InvalidArgumentException($vAT_BreakdownElementArrayErrorMessage, __LINE__);
        }
        $this->VAT_BreakdownElement = $vAT_BreakdownElement;
        return $this;
    }
    /**
     * Add item to VAT_BreakdownElement value
     * @throws \InvalidArgumentException
     * @param \StructType\VAT_BreakdownElementType $item
     * @return \StructType\AccountedPriceType
     */
    public function addToVAT_BreakdownElement(\StructType\VAT_BreakdownElementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VAT_BreakdownElementType) {
            throw new \InvalidArgumentException(sprintf('The VAT_BreakdownElement property can only contain items of type \StructType\VAT_BreakdownElementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VAT_BreakdownElement[] = $item;
        return $this;
    }
}
