<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountedOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Accounted Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
 * services that are not necessarily Journey based (e.g. subscription services).
 * @subpackage Structs
 */
class AccountedOrderType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The OrderItem
     * Meta information extracted from the WSDL
     * - documentation: An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\AccountedOrderItemType[]
     */
    public $OrderItem;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The BilateralTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: A bilaterally agreed limitation or restriction of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BilateralTimeLimitType[]
     */
    public $BilateralTimeLimit;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is created. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DepositTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date by which a deposit must be paid for an order Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositTimeLimitDateTime;
    /**
     * The ForfeitedInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Order Forfeited Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedForfeitedInfoListType
     */
    public $ForfeitedInfoList;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDateTime;
    /**
     * The NamingTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second,
     * and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamingTimeLimitDateTime;
    /**
     * The OrderKeys
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderStructureKeyType[]
     */
    public $OrderKeys;
    /**
     * The OrderVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order used to track the evolution of an Order and the changes made to it. | Order version number BDT.
     * - base: xs:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrderVersionNumber;
    /**
     * The OriginalOrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginalOrderID;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentInfoType[]
     */
    public $PaymentInfo;
    /**
     * The PenaltyInfoList
     * Meta information extracted from the WSDL
     * - documentation: list of Order Penalty Information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPenaltyInfoListType
     */
    public $PenaltyInfoList;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Status instance. See ATSB Codeset OrderStatus for possible values. | The possible statuses of an Order {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Status, coded{/codeListName}
     * {codeListIdentifier}ORDERSTATUS{/codeListIdentifier} | represents the statuses of an Order
     * - base: OrderStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: An amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountedPriceType
     */
    public $TotalPrice;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for AccountedOrderType
     * @uses AccountedOrderType::setOrderID()
     * @uses AccountedOrderType::setOrderItem()
     * @uses AccountedOrderType::setOwnerCode()
     * @uses AccountedOrderType::setBilateralTimeLimit()
     * @uses AccountedOrderType::setBookingRef()
     * @uses AccountedOrderType::setCommission()
     * @uses AccountedOrderType::setCreationDateTime()
     * @uses AccountedOrderType::setDepositTimeLimitDateTime()
     * @uses AccountedOrderType::setForfeitedInfoList()
     * @uses AccountedOrderType::setLastModifiedDateTime()
     * @uses AccountedOrderType::setNamingTimeLimitDateTime()
     * @uses AccountedOrderType::setOrderKeys()
     * @uses AccountedOrderType::setOrderVersionNumber()
     * @uses AccountedOrderType::setOriginalOrderID()
     * @uses AccountedOrderType::setPaxGroup()
     * @uses AccountedOrderType::setPaymentInfo()
     * @uses AccountedOrderType::setPenaltyInfoList()
     * @uses AccountedOrderType::setStatusCode()
     * @uses AccountedOrderType::setTotalPrice()
     * @uses AccountedOrderType::setWebAddressURI()
     * @param string $orderID
     * @param \StructType\AccountedOrderItemType[] $orderItem
     * @param string $ownerCode
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\CommissionType[] $commission
     * @param string $creationDateTime
     * @param string $depositTimeLimitDateTime
     * @param \StructType\AccountedForfeitedInfoListType $forfeitedInfoList
     * @param string $lastModifiedDateTime
     * @param string $namingTimeLimitDateTime
     * @param \StructType\OrderStructureKeyType[] $orderKeys
     * @param int $orderVersionNumber
     * @param string $originalOrderID
     * @param \StructType\PaxGroupType $paxGroup
     * @param \StructType\PaymentInfoType[] $paymentInfo
     * @param \StructType\AccountedPenaltyInfoListType $penaltyInfoList
     * @param string $statusCode
     * @param \StructType\AccountedPriceType $totalPrice
     * @param string $webAddressURI
     */
    public function __construct($orderID = null, array $orderItem = array(), $ownerCode = null, array $bilateralTimeLimit = array(), array $bookingRef = array(), array $commission = array(), $creationDateTime = null, $depositTimeLimitDateTime = null, \StructType\AccountedForfeitedInfoListType $forfeitedInfoList = null, $lastModifiedDateTime = null, $namingTimeLimitDateTime = null, array $orderKeys = array(), $orderVersionNumber = null, $originalOrderID = null, \StructType\PaxGroupType $paxGroup = null, array $paymentInfo = array(), \StructType\AccountedPenaltyInfoListType $penaltyInfoList = null, $statusCode = null, \StructType\AccountedPriceType $totalPrice = null, $webAddressURI = null)
    {
        $this
            ->setOrderID($orderID)
            ->setOrderItem($orderItem)
            ->setOwnerCode($ownerCode)
            ->setBilateralTimeLimit($bilateralTimeLimit)
            ->setBookingRef($bookingRef)
            ->setCommission($commission)
            ->setCreationDateTime($creationDateTime)
            ->setDepositTimeLimitDateTime($depositTimeLimitDateTime)
            ->setForfeitedInfoList($forfeitedInfoList)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setNamingTimeLimitDateTime($namingTimeLimitDateTime)
            ->setOrderKeys($orderKeys)
            ->setOrderVersionNumber($orderVersionNumber)
            ->setOriginalOrderID($originalOrderID)
            ->setPaxGroup($paxGroup)
            ->setPaymentInfo($paymentInfo)
            ->setPenaltyInfoList($penaltyInfoList)
            ->setStatusCode($statusCode)
            ->setTotalPrice($totalPrice)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\AccountedOrderType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\AccountedOrderItemType[]
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderTypeOrderItemItem) {
            // validation for constraint: itemType
            if (!$accountedOrderTypeOrderItemItem instanceof \StructType\AccountedOrderItemType) {
                $invalidValues[] = is_object($accountedOrderTypeOrderItemItem) ? get_class($accountedOrderTypeOrderItemItem) : sprintf('%s(%s)', gettype($accountedOrderTypeOrderItemItem), var_export($accountedOrderTypeOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItem property can only contain items of type \StructType\AccountedOrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedOrderItemType[] $orderItem
     * @return \StructType\AccountedOrderType
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountedOrderItemType $item
     * @return \StructType\AccountedOrderType
     */
    public function addToOrderItem(\StructType\AccountedOrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountedOrderItemType) {
            throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of type \StructType\AccountedOrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItem[] = $item;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\AccountedOrderType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get BilateralTimeLimit value
     * @return \StructType\BilateralTimeLimitType[]|null
     */
    public function getBilateralTimeLimit()
    {
        return $this->BilateralTimeLimit;
    }
    /**
     * This method is responsible for validating the values passed to the setBilateralTimeLimit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilateralTimeLimit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderTypeBilateralTimeLimitItem) {
            // validation for constraint: itemType
            if (!$accountedOrderTypeBilateralTimeLimitItem instanceof \StructType\BilateralTimeLimitType) {
                $invalidValues[] = is_object($accountedOrderTypeBilateralTimeLimitItem) ? get_class($accountedOrderTypeBilateralTimeLimitItem) : sprintf('%s(%s)', gettype($accountedOrderTypeBilateralTimeLimitItem), var_export($accountedOrderTypeBilateralTimeLimitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @return \StructType\AccountedOrderType
     */
    public function setBilateralTimeLimit(array $bilateralTimeLimit = array())
    {
        // validation for constraint: array
        if ('' !== ($bilateralTimeLimitArrayErrorMessage = self::validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit($bilateralTimeLimit))) {
            throw new \InvalidArgumentException($bilateralTimeLimitArrayErrorMessage, __LINE__);
        }
        $this->BilateralTimeLimit = $bilateralTimeLimit;
        return $this;
    }
    /**
     * Add item to BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType $item
     * @return \StructType\AccountedOrderType
     */
    public function addToBilateralTimeLimit(\StructType\BilateralTimeLimitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BilateralTimeLimitType) {
            throw new \InvalidArgumentException(sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BilateralTimeLimit[] = $item;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$accountedOrderTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($accountedOrderTypeBookingRefItem) ? get_class($accountedOrderTypeBookingRefItem) : sprintf('%s(%s)', gettype($accountedOrderTypeBookingRefItem), var_export($accountedOrderTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\AccountedOrderType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\AccountedOrderType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$accountedOrderTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($accountedOrderTypeCommissionItem) ? get_class($accountedOrderTypeCommissionItem) : sprintf('%s(%s)', gettype($accountedOrderTypeCommissionItem), var_export($accountedOrderTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\AccountedOrderType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\AccountedOrderType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\AccountedOrderType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get DepositTimeLimitDateTime value
     * @return string|null
     */
    public function getDepositTimeLimitDateTime()
    {
        return $this->DepositTimeLimitDateTime;
    }
    /**
     * Set DepositTimeLimitDateTime value
     * @param string $depositTimeLimitDateTime
     * @return \StructType\AccountedOrderType
     */
    public function setDepositTimeLimitDateTime($depositTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($depositTimeLimitDateTime) && !is_string($depositTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTimeLimitDateTime, true), gettype($depositTimeLimitDateTime)), __LINE__);
        }
        $this->DepositTimeLimitDateTime = $depositTimeLimitDateTime;
        return $this;
    }
    /**
     * Get ForfeitedInfoList value
     * @return \StructType\AccountedForfeitedInfoListType|null
     */
    public function getForfeitedInfoList()
    {
        return $this->ForfeitedInfoList;
    }
    /**
     * Set ForfeitedInfoList value
     * @param \StructType\AccountedForfeitedInfoListType $forfeitedInfoList
     * @return \StructType\AccountedOrderType
     */
    public function setForfeitedInfoList(\StructType\AccountedForfeitedInfoListType $forfeitedInfoList = null)
    {
        $this->ForfeitedInfoList = $forfeitedInfoList;
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * @return string|null
     */
    public function getLastModifiedDateTime()
    {
        return $this->LastModifiedDateTime;
    }
    /**
     * Set LastModifiedDateTime value
     * @param string $lastModifiedDateTime
     * @return \StructType\AccountedOrderType
     */
    public function setLastModifiedDateTime($lastModifiedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDateTime) && !is_string($lastModifiedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDateTime, true), gettype($lastModifiedDateTime)), __LINE__);
        }
        $this->LastModifiedDateTime = $lastModifiedDateTime;
        return $this;
    }
    /**
     * Get NamingTimeLimitDateTime value
     * @return string|null
     */
    public function getNamingTimeLimitDateTime()
    {
        return $this->NamingTimeLimitDateTime;
    }
    /**
     * Set NamingTimeLimitDateTime value
     * @param string $namingTimeLimitDateTime
     * @return \StructType\AccountedOrderType
     */
    public function setNamingTimeLimitDateTime($namingTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($namingTimeLimitDateTime) && !is_string($namingTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namingTimeLimitDateTime, true), gettype($namingTimeLimitDateTime)), __LINE__);
        }
        $this->NamingTimeLimitDateTime = $namingTimeLimitDateTime;
        return $this;
    }
    /**
     * Get OrderKeys value
     * @return \StructType\OrderStructureKeyType[]|null
     */
    public function getOrderKeys()
    {
        return $this->OrderKeys;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderKeys method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderKeys method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderKeysForArrayConstraintsFromSetOrderKeys(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderTypeOrderKeysItem) {
            // validation for constraint: itemType
            if (!$accountedOrderTypeOrderKeysItem instanceof \StructType\OrderStructureKeyType) {
                $invalidValues[] = is_object($accountedOrderTypeOrderKeysItem) ? get_class($accountedOrderTypeOrderKeysItem) : sprintf('%s(%s)', gettype($accountedOrderTypeOrderKeysItem), var_export($accountedOrderTypeOrderKeysItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderKeys property can only contain items of type \StructType\OrderStructureKeyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderKeys value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStructureKeyType[] $orderKeys
     * @return \StructType\AccountedOrderType
     */
    public function setOrderKeys(array $orderKeys = array())
    {
        // validation for constraint: array
        if ('' !== ($orderKeysArrayErrorMessage = self::validateOrderKeysForArrayConstraintsFromSetOrderKeys($orderKeys))) {
            throw new \InvalidArgumentException($orderKeysArrayErrorMessage, __LINE__);
        }
        $this->OrderKeys = $orderKeys;
        return $this;
    }
    /**
     * Add item to OrderKeys value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStructureKeyType $item
     * @return \StructType\AccountedOrderType
     */
    public function addToOrderKeys(\StructType\OrderStructureKeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderStructureKeyType) {
            throw new \InvalidArgumentException(sprintf('The OrderKeys property can only contain items of type \StructType\OrderStructureKeyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderKeys[] = $item;
        return $this;
    }
    /**
     * Get OrderVersionNumber value
     * @return int|null
     */
    public function getOrderVersionNumber()
    {
        return $this->OrderVersionNumber;
    }
    /**
     * Set OrderVersionNumber value
     * @param int $orderVersionNumber
     * @return \StructType\AccountedOrderType
     */
    public function setOrderVersionNumber($orderVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderVersionNumber) && !(is_int($orderVersionNumber) || ctype_digit($orderVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderVersionNumber, true), gettype($orderVersionNumber)), __LINE__);
        }
        $this->OrderVersionNumber = $orderVersionNumber;
        return $this;
    }
    /**
     * Get OriginalOrderID value
     * @return string|null
     */
    public function getOriginalOrderID()
    {
        return $this->OriginalOrderID;
    }
    /**
     * Set OriginalOrderID value
     * @param string $originalOrderID
     * @return \StructType\AccountedOrderType
     */
    public function setOriginalOrderID($originalOrderID = null)
    {
        // validation for constraint: string
        if (!is_null($originalOrderID) && !is_string($originalOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalOrderID, true), gettype($originalOrderID)), __LINE__);
        }
        $this->OriginalOrderID = $originalOrderID;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\AccountedOrderType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\PaymentInfoType[]|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentInfoForArrayConstraintsFromSetPaymentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accountedOrderTypePaymentInfoItem) {
            // validation for constraint: itemType
            if (!$accountedOrderTypePaymentInfoItem instanceof \StructType\PaymentInfoType) {
                $invalidValues[] = is_object($accountedOrderTypePaymentInfoItem) ? get_class($accountedOrderTypePaymentInfoItem) : sprintf('%s(%s)', gettype($accountedOrderTypePaymentInfoItem), var_export($accountedOrderTypePaymentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentInfo property can only contain items of type \StructType\PaymentInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentInfoType[] $paymentInfo
     * @return \StructType\AccountedOrderType
     */
    public function setPaymentInfo(array $paymentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentInfoArrayErrorMessage = self::validatePaymentInfoForArrayConstraintsFromSetPaymentInfo($paymentInfo))) {
            throw new \InvalidArgumentException($paymentInfoArrayErrorMessage, __LINE__);
        }
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Add item to PaymentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentInfoType $item
     * @return \StructType\AccountedOrderType
     */
    public function addToPaymentInfo(\StructType\PaymentInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentInfoType) {
            throw new \InvalidArgumentException(sprintf('The PaymentInfo property can only contain items of type \StructType\PaymentInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentInfo[] = $item;
        return $this;
    }
    /**
     * Get PenaltyInfoList value
     * @return \StructType\AccountedPenaltyInfoListType|null
     */
    public function getPenaltyInfoList()
    {
        return $this->PenaltyInfoList;
    }
    /**
     * Set PenaltyInfoList value
     * @param \StructType\AccountedPenaltyInfoListType $penaltyInfoList
     * @return \StructType\AccountedOrderType
     */
    public function setPenaltyInfoList(\StructType\AccountedPenaltyInfoListType $penaltyInfoList = null)
    {
        $this->PenaltyInfoList = $penaltyInfoList;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\AccountedOrderType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return \StructType\AccountedPriceType|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param \StructType\AccountedPriceType $totalPrice
     * @return \StructType\AccountedOrderType
     */
    public function setTotalPrice(\StructType\AccountedPriceType $totalPrice = null)
    {
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\AccountedOrderType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
