<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountableDocType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
 * @subpackage Structs
 */
class AccountableDocType extends AbstractStructBase
{
    /**
     * The DocNumber
     * Meta information extracted from the WSDL
     * - documentation: MCO, Ticket or EMD reference number, indicating a previously issued document | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DateOfIssue
     * Meta information extracted from the WSDL
     * - documentation: The Date that the Document was issued. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateOfIssue;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - documentation: Type of Accountable Document. Use ATS Codeset 1001. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocType;
    /**
     * Constructor method for AccountableDocType
     * @uses AccountableDocType::setDocNumber()
     * @uses AccountableDocType::setDateOfIssue()
     * @uses AccountableDocType::setDocType()
     * @param string $docNumber
     * @param string $dateOfIssue
     * @param string $docType
     */
    public function __construct($docNumber = null, $dateOfIssue = null, $docType = null)
    {
        $this
            ->setDocNumber($docNumber)
            ->setDateOfIssue($dateOfIssue)
            ->setDocType($docType);
    }
    /**
     * Get DocNumber value
     * @return string
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\AccountableDocType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DateOfIssue value
     * @return string|null
     */
    public function getDateOfIssue()
    {
        return $this->DateOfIssue;
    }
    /**
     * Set DateOfIssue value
     * @param string $dateOfIssue
     * @return \StructType\AccountableDocType
     */
    public function setDateOfIssue($dateOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssue) && !is_string($dateOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfIssue, true), gettype($dateOfIssue)), __LINE__);
        }
        $this->DateOfIssue = $dateOfIssue;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\AccountableDocType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docType, true), gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
}
