<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptOrderItemListType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Create Order Item's.
 * @subpackage Structs
 */
class AcceptOrderItemListType extends AbstractStructBase
{
    /**
     * The CreateOrderItem
     * Meta information extracted from the WSDL
     * - documentation: Used for selling by value (long sells) rather than selling by reference.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\CreateOrderItemType[]
     */
    public $CreateOrderItem;
    /**
     * Constructor method for AcceptOrderItemListType
     * @uses AcceptOrderItemListType::setCreateOrderItem()
     * @param \StructType\CreateOrderItemType[] $createOrderItem
     */
    public function __construct(array $createOrderItem = array())
    {
        $this
            ->setCreateOrderItem($createOrderItem);
    }
    /**
     * Get CreateOrderItem value
     * @return \StructType\CreateOrderItemType[]
     */
    public function getCreateOrderItem()
    {
        return $this->CreateOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setCreateOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreateOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreateOrderItemForArrayConstraintsFromSetCreateOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $acceptOrderItemListTypeCreateOrderItemItem) {
            // validation for constraint: itemType
            if (!$acceptOrderItemListTypeCreateOrderItemItem instanceof \StructType\CreateOrderItemType) {
                $invalidValues[] = is_object($acceptOrderItemListTypeCreateOrderItemItem) ? get_class($acceptOrderItemListTypeCreateOrderItemItem) : sprintf('%s(%s)', gettype($acceptOrderItemListTypeCreateOrderItemItem), var_export($acceptOrderItemListTypeCreateOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CreateOrderItem property can only contain items of type \StructType\CreateOrderItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CreateOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\CreateOrderItemType[] $createOrderItem
     * @return \StructType\AcceptOrderItemListType
     */
    public function setCreateOrderItem(array $createOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($createOrderItemArrayErrorMessage = self::validateCreateOrderItemForArrayConstraintsFromSetCreateOrderItem($createOrderItem))) {
            throw new \InvalidArgumentException($createOrderItemArrayErrorMessage, __LINE__);
        }
        $this->CreateOrderItem = $createOrderItem;
        return $this;
    }
    /**
     * Add item to CreateOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\CreateOrderItemType $item
     * @return \StructType\AcceptOrderItemListType
     */
    public function addToCreateOrderItem(\StructType\CreateOrderItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CreateOrderItemType) {
            throw new \InvalidArgumentException(sprintf('The CreateOrderItem property can only contain items of type \StructType\CreateOrderItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CreateOrderItem[] = $item;
        return $this;
    }
}
