<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALaCarteOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A priced grouping of one or more services within an Offer. The A La Carte Offer Item assigns a total price for all included services for all passengers and all segments referenced. Once constructed, the OfferItem cannot be modified.
 * @subpackage Structs
 */
class ALaCarteOfferItemType extends AbstractStructBase
{
    /**
     * The Eligibility
     * Meta information extracted from the WSDL
     * - documentation: Refers to the Passengers, Price class or segments for which this offer item is eligible.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EligibilityType
     */
    public $Eligibility;
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Offer. Exceeding 64 characters or use of dashes is not recommended. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemID;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can be sold to multiple
     * passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ALaCarteServiceType
     */
    public $Service;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $UnitPrice;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The OfferItemTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specify the type of Offer Item being presented to the Customer. Using new PADIS codeset -initial content -RET - Retail -WHO - Wholesale -COR - Corporate | A code is a character string of letters, numbers, special characters (except
     * escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferItemTypeCode;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The PaymentTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: Payment Time Limit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentTimeLimitType
     */
    public $PaymentTimeLimit;
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the price of an offer item is guaranteed. In the absence of the price guarantee time limit, the price is not guaranteed. Upon expiry, the price may no longer be guaranteed and either a new shopping process should
     * begin, or the offer should be repriced resulting in a new Offer. Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item. At Order creation (or change)
     * the airline can increase the remaining length of time beyond the original time limit should they wish to. Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline. | A date time
     * identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * The RichMedia
     * Meta information extracted from the WSDL
     * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MediaResourceRefType[]
     */
    public $RichMedia;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for ALaCarteOfferItemType
     * @uses ALaCarteOfferItemType::setEligibility()
     * @uses ALaCarteOfferItemType::setOfferItemID()
     * @uses ALaCarteOfferItemType::setService()
     * @uses ALaCarteOfferItemType::setUnitPrice()
     * @uses ALaCarteOfferItemType::setAirlineTaxonomy()
     * @uses ALaCarteOfferItemType::setCancelRestrictions()
     * @uses ALaCarteOfferItemType::setChangeRestrictions()
     * @uses ALaCarteOfferItemType::setCommission()
     * @uses ALaCarteOfferItemType::setOfferItemTypeCode()
     * @uses ALaCarteOfferItemType::setOwnerCode()
     * @uses ALaCarteOfferItemType::setPaymentTimeLimit()
     * @uses ALaCarteOfferItemType::setPriceGuaranteeTimeLimitDateTime()
     * @uses ALaCarteOfferItemType::setRichMedia()
     * @uses ALaCarteOfferItemType::setWebAddressURI()
     * @param \StructType\EligibilityType $eligibility
     * @param string $offerItemID
     * @param \StructType\ALaCarteServiceType $service
     * @param \StructType\PriceType $unitPrice
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\CommissionType[] $commission
     * @param string $offerItemTypeCode
     * @param string $ownerCode
     * @param \StructType\PaymentTimeLimitType $paymentTimeLimit
     * @param string $priceGuaranteeTimeLimitDateTime
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @param string $webAddressURI
     */
    public function __construct(\StructType\EligibilityType $eligibility = null, $offerItemID = null, \StructType\ALaCarteServiceType $service = null, \StructType\PriceType $unitPrice = null, array $airlineTaxonomy = array(), array $cancelRestrictions = array(), array $changeRestrictions = array(), array $commission = array(), $offerItemTypeCode = null, $ownerCode = null, \StructType\PaymentTimeLimitType $paymentTimeLimit = null, $priceGuaranteeTimeLimitDateTime = null, array $richMedia = array(), $webAddressURI = null)
    {
        $this
            ->setEligibility($eligibility)
            ->setOfferItemID($offerItemID)
            ->setService($service)
            ->setUnitPrice($unitPrice)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setCommission($commission)
            ->setOfferItemTypeCode($offerItemTypeCode)
            ->setOwnerCode($ownerCode)
            ->setPaymentTimeLimit($paymentTimeLimit)
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime)
            ->setRichMedia($richMedia)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get Eligibility value
     * @return \StructType\EligibilityType
     */
    public function getEligibility()
    {
        return $this->Eligibility;
    }
    /**
     * Set Eligibility value
     * @param \StructType\EligibilityType $eligibility
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setEligibility(\StructType\EligibilityType $eligibility = null)
    {
        $this->Eligibility = $eligibility;
        return $this;
    }
    /**
     * Get OfferItemID value
     * @return string
     */
    public function getOfferItemID()
    {
        return $this->OfferItemID;
    }
    /**
     * Set OfferItemID value
     * @param string $offerItemID
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        $this->OfferItemID = $offerItemID;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ALaCarteServiceType
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\ALaCarteServiceType $service
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setService(\StructType\ALaCarteServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return \StructType\PriceType
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param \StructType\PriceType $unitPrice
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setUnitPrice(\StructType\PriceType $unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLaCarteOfferItemTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$aLaCarteOfferItemTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($aLaCarteOfferItemTypeAirlineTaxonomyItem) ? get_class($aLaCarteOfferItemTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($aLaCarteOfferItemTypeAirlineTaxonomyItem), var_export($aLaCarteOfferItemTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\ALaCarteOfferItemType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLaCarteOfferItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$aLaCarteOfferItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($aLaCarteOfferItemTypeCancelRestrictionsItem) ? get_class($aLaCarteOfferItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($aLaCarteOfferItemTypeCancelRestrictionsItem), var_export($aLaCarteOfferItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\ALaCarteOfferItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLaCarteOfferItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$aLaCarteOfferItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($aLaCarteOfferItemTypeChangeRestrictionsItem) ? get_class($aLaCarteOfferItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($aLaCarteOfferItemTypeChangeRestrictionsItem), var_export($aLaCarteOfferItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\ALaCarteOfferItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLaCarteOfferItemTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$aLaCarteOfferItemTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($aLaCarteOfferItemTypeCommissionItem) ? get_class($aLaCarteOfferItemTypeCommissionItem) : sprintf('%s(%s)', gettype($aLaCarteOfferItemTypeCommissionItem), var_export($aLaCarteOfferItemTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\ALaCarteOfferItemType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get OfferItemTypeCode value
     * @return string|null
     */
    public function getOfferItemTypeCode()
    {
        return $this->OfferItemTypeCode;
    }
    /**
     * Set OfferItemTypeCode value
     * @param string $offerItemTypeCode
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setOfferItemTypeCode($offerItemTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemTypeCode) && !is_string($offerItemTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemTypeCode, true), gettype($offerItemTypeCode)), __LINE__);
        }
        $this->OfferItemTypeCode = $offerItemTypeCode;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string|null
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get PaymentTimeLimit value
     * @return \StructType\PaymentTimeLimitType|null
     */
    public function getPaymentTimeLimit()
    {
        return $this->PaymentTimeLimit;
    }
    /**
     * Set PaymentTimeLimit value
     * @param \StructType\PaymentTimeLimitType $paymentTimeLimit
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setPaymentTimeLimit(\StructType\PaymentTimeLimitType $paymentTimeLimit = null)
    {
        $this->PaymentTimeLimit = $paymentTimeLimit;
        return $this;
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get RichMedia value
     * @return \StructType\MediaResourceRefType[]|null
     */
    public function getRichMedia()
    {
        return $this->RichMedia;
    }
    /**
     * This method is responsible for validating the values passed to the setRichMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRichMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRichMediaForArrayConstraintsFromSetRichMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aLaCarteOfferItemTypeRichMediaItem) {
            // validation for constraint: itemType
            if (!$aLaCarteOfferItemTypeRichMediaItem instanceof \StructType\MediaResourceRefType) {
                $invalidValues[] = is_object($aLaCarteOfferItemTypeRichMediaItem) ? get_class($aLaCarteOfferItemTypeRichMediaItem) : sprintf('%s(%s)', gettype($aLaCarteOfferItemTypeRichMediaItem), var_export($aLaCarteOfferItemTypeRichMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType[] $richMedia
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setRichMedia(array $richMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($richMediaArrayErrorMessage = self::validateRichMediaForArrayConstraintsFromSetRichMedia($richMedia))) {
            throw new \InvalidArgumentException($richMediaArrayErrorMessage, __LINE__);
        }
        $this->RichMedia = $richMedia;
        return $this;
    }
    /**
     * Add item to RichMedia value
     * @throws \InvalidArgumentException
     * @param \StructType\MediaResourceRefType $item
     * @return \StructType\ALaCarteOfferItemType
     */
    public function addToRichMedia(\StructType\MediaResourceRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MediaResourceRefType) {
            throw new \InvalidArgumentException(sprintf('The RichMedia property can only contain items of type \StructType\MediaResourceRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RichMedia[] = $item;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\ALaCarteOfferItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
