<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for WeightUnitCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: List of Weight Unit Codes. Subset of UN/CEFACT Recommendation 20. {codeListAgencyName}AIDM (extract from UN/CEFACT){/codeListAgencyName}
 * @subpackage Enumerations
 */
class WeightUnitCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'KGM'
     * Meta information extracted from the WSDL
     * - documentation: Kilogram
     * @return string 'KGM'
     */
    const VALUE_KGM = 'KGM';
    /**
     * Constant for value 'LBR'
     * Meta information extracted from the WSDL
     * - documentation: US Pound
     * @return string 'LBR'
     */
    const VALUE_LBR = 'LBR';
    /**
     * Return allowed values
     * @uses self::VALUE_KGM
     * @uses self::VALUE_LBR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KGM,
            self::VALUE_LBR,
        );
    }
}
