<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Ticketless EnumType
 * Meta information extracted from the WSDL
 * - documentation: Fare can be purchased without issuing a ticket. Values are:Y = Ticketless purchase possibleN = Ticketless purchase not possibleExample: Y
 * @subpackage Enumerations
 */
class Ticketless extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return allowed values
     * @uses self::VALUE_Y
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_Y,
            self::VALUE_N,
        );
    }
}
