<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentTrxChannelCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Lists types of payment transaction channels
 * @subpackage Enumerations
 */
class PaymentTrxChannelCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'EC'
     * Meta information extracted from the WSDL
     * - documentation: Electronic commerce
     * @return string 'EC'
     */
    const VALUE_EC = 'EC';
    /**
     * Constant for value 'FA'
     * Meta information extracted from the WSDL
     * - documentation: Face to face.
     * @return string 'FA'
     */
    const VALUE_FA = 'FA';
    /**
     * Constant for value 'MO'
     * Meta information extracted from the WSDL
     * - documentation: Mail order (paper mail, fax and email).
     * @return string 'MO'
     */
    const VALUE_MO = 'MO';
    /**
     * Constant for value 'NS'
     * Meta information extracted from the WSDL
     * - documentation: Other not specified.
     * @return string 'NS'
     */
    const VALUE_NS = 'NS';
    /**
     * Constant for value 'TO'
     * Meta information extracted from the WSDL
     * - documentation: Telephone order/IVR
     * @return string 'TO'
     */
    const VALUE_TO = 'TO';
    /**
     * Return allowed values
     * @uses self::VALUE_EC
     * @uses self::VALUE_FA
     * @uses self::VALUE_MO
     * @uses self::VALUE_NS
     * @uses self::VALUE_TO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EC,
            self::VALUE_FA,
            self::VALUE_MO,
            self::VALUE_NS,
            self::VALUE_TO,
        );
    }
}
