<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Meals EnumType
 * Meta information extracted from the WSDL
 * - documentation: Indicates what types of meals are served. Meal codes are IATA standard:B = BreakfastK = Continental BreakfastV = Continental BreakfastL = LunchD = DinnerS = Snack or BrunchO = Cold MealH = Hot MealM = Meal (Non-Specific)R =
 * RefreshmentC = Alcoholic Beverages ComplimentaryF = Food for PurchaseP = Alcoholic Beverages for PurchaseY = Duty Free Sales AvailableG = Light LunchN = NO MEALS Example: B
 * @subpackage Enumerations
 */
class Meals extends AbstractStructEnumBase
{
    /**
     * Constant for value 'B'
     * @return string 'B'
     */
    const VALUE_B = 'B';
    /**
     * Constant for value 'K'
     * @return string 'K'
     */
    const VALUE_K = 'K';
    /**
     * Constant for value 'V'
     * @return string 'V'
     */
    const VALUE_V = 'V';
    /**
     * Constant for value 'L'
     * @return string 'L'
     */
    const VALUE_L = 'L';
    /**
     * Constant for value 'D'
     * @return string 'D'
     */
    const VALUE_D = 'D';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'O'
     * @return string 'O'
     */
    const VALUE_O = 'O';
    /**
     * Constant for value 'H'
     * @return string 'H'
     */
    const VALUE_H = 'H';
    /**
     * Constant for value 'M'
     * @return string 'M'
     */
    const VALUE_M = 'M';
    /**
     * Constant for value 'R'
     * @return string 'R'
     */
    const VALUE_R = 'R';
    /**
     * Constant for value 'C'
     * @return string 'C'
     */
    const VALUE_C = 'C';
    /**
     * Constant for value 'F'
     * @return string 'F'
     */
    const VALUE_F = 'F';
    /**
     * Constant for value 'P'
     * @return string 'P'
     */
    const VALUE_P = 'P';
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'G'
     * @return string 'G'
     */
    const VALUE_G = 'G';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return allowed values
     * @uses self::VALUE_B
     * @uses self::VALUE_K
     * @uses self::VALUE_V
     * @uses self::VALUE_L
     * @uses self::VALUE_D
     * @uses self::VALUE_S
     * @uses self::VALUE_O
     * @uses self::VALUE_H
     * @uses self::VALUE_M
     * @uses self::VALUE_R
     * @uses self::VALUE_C
     * @uses self::VALUE_F
     * @uses self::VALUE_P
     * @uses self::VALUE_Y
     * @uses self::VALUE_G
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_B,
            self::VALUE_K,
            self::VALUE_V,
            self::VALUE_L,
            self::VALUE_D,
            self::VALUE_S,
            self::VALUE_O,
            self::VALUE_H,
            self::VALUE_M,
            self::VALUE_R,
            self::VALUE_C,
            self::VALUE_F,
            self::VALUE_P,
            self::VALUE_Y,
            self::VALUE_G,
            self::VALUE_N,
        );
    }
}
