<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for LevelTypeCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: This will identify the type of re fundability for the condition. This will be one of the following. Fully Refundable Partly Refundable Non Refundable
 * @subpackage Enumerations
 */
class LevelTypeCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Full'
     * Meta information extracted from the WSDL
     * - documentation: Fully Refundable
     * @return string 'Full'
     */
    const VALUE_FULL = 'Full';
    /**
     * Constant for value 'None'
     * Meta information extracted from the WSDL
     * - documentation: Non Refundable.
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Partial'
     * Meta information extracted from the WSDL
     * - documentation: Partial Refundable.
     * @return string 'Partial'
     */
    const VALUE_PARTIAL = 'Partial';
    /**
     * Return allowed values
     * @uses self::VALUE_FULL
     * @uses self::VALUE_NONE
     * @uses self::VALUE_PARTIAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL,
            self::VALUE_NONE,
            self::VALUE_PARTIAL,
        );
    }
}
