<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DistributionChainRoleCodeContentType EnumType
 * Meta information extracted from the WSDL
 * - documentation: The list of allowable roles in a distribution chain. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}PADIS Codeset 9873{/codeListName}
 * @subpackage Enumerations
 */
class DistributionChainRoleCodeContentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Carrier'
     * Meta information extracted from the WSDL
     * - documentation: An organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage.
     * @return string 'Carrier'
     */
    const VALUE_CARRIER = 'Carrier';
    /**
     * Constant for value 'Distributor'
     * Meta information extracted from the WSDL
     * - documentation: An organization that provides a distribution capability such as a certain type of Consolidator, an Aggregator, more generally an intermediary.
     * @return string 'Distributor'
     */
    const VALUE_DISTRIBUTOR = 'Distributor';
    /**
     * Constant for value 'Seller'
     * Meta information extracted from the WSDL
     * - documentation: An organization that offers a shopping capability to a shopper.
     * @return string 'Seller'
     */
    const VALUE_SELLER = 'Seller';
    /**
     * Return allowed values
     * @uses self::VALUE_CARRIER
     * @uses self::VALUE_DISTRIBUTOR
     * @uses self::VALUE_SELLER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CARRIER,
            self::VALUE_DISTRIBUTOR,
            self::VALUE_SELLER,
        );
    }
}
