<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DifferentialTypeCode EnumType
 * Meta information extracted from the WSDL
 * - documentation: Several types of action are possible when the customer selects a reshopped offer-
 * @subpackage Enumerations
 */
class DifferentialTypeCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AddCol'
     * Meta information extracted from the WSDL
     * - documentation: the change will result into a new payment from the customer (applies to change scenarios)
     * @return string 'AddCol'
     */
    const VALUE_ADD_COL = 'AddCol';
    /**
     * Constant for value 'AddColAndRefund'
     * Meta information extracted from the WSDL
     * - documentation: the change will result into both a new payment from customer and a customer refund (applies to cancellation and change scenarios)
     * @return string 'AddColAndRefund'
     */
    const VALUE_ADD_COL_AND_REFUND = 'AddColAndRefund';
    /**
     * Constant for value 'AddColAndResidual'
     * Meta information extracted from the WSDL
     * - documentation: the change will result into both a new payment from customer and a determined amount kept by airline for future use (applies to cancellation and change scenarios)
     * @return string 'AddColAndResidual'
     */
    const VALUE_ADD_COL_AND_RESIDUAL = 'AddColAndResidual';
    /**
     * Constant for value 'EvenExchange'
     * Meta information extracted from the WSDL
     * - documentation: the change does not have any financial impact to the customer (applies to change scenarios)
     * @return string 'EvenExchange'
     */
    const VALUE_EVEN_EXCHANGE = 'EvenExchange';
    /**
     * Constant for value 'Refund'
     * Meta information extracted from the WSDL
     * - documentation: the change will result into a customer refund (applies to cancellations and change scenarios)
     * @return string 'Refund'
     */
    const VALUE_REFUND = 'Refund';
    /**
     * Constant for value 'Residual'
     * Meta information extracted from the WSDL
     * - documentation: the change will result into a determined amount kept by airline for future use (applies to cancellations and change scenarios)
     * @return string 'Residual'
     */
    const VALUE_RESIDUAL = 'Residual';
    /**
     * Constant for value 'Reusable'
     * Meta information extracted from the WSDL
     * - documentation: the financial result of the change will be determined when customer will come back to select new journey options (applies to change scenarios when customer does not yet know how to reuse his money)
     * @return string 'Reusable'
     */
    const VALUE_REUSABLE = 'Reusable';
    /**
     * Constant for value 'Void'
     * Meta information extracted from the WSDL
     * - documentation: the financial result of the change will be determined when customer will come back to select new journey options (applies to change scenarios when customer does not yet know how to reuse his money)
     * @return string 'Void'
     */
    const VALUE_VOID = 'Void';
    /**
     * Return allowed values
     * @uses self::VALUE_ADD_COL
     * @uses self::VALUE_ADD_COL_AND_REFUND
     * @uses self::VALUE_ADD_COL_AND_RESIDUAL
     * @uses self::VALUE_EVEN_EXCHANGE
     * @uses self::VALUE_REFUND
     * @uses self::VALUE_RESIDUAL
     * @uses self::VALUE_REUSABLE
     * @uses self::VALUE_VOID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD_COL,
            self::VALUE_ADD_COL_AND_REFUND,
            self::VALUE_ADD_COL_AND_RESIDUAL,
            self::VALUE_EVEN_EXCHANGE,
            self::VALUE_REFUND,
            self::VALUE_RESIDUAL,
            self::VALUE_REUSABLE,
            self::VALUE_VOID,
        );
    }
}
